/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.BigramHMMemitter;
import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMNameTagger;
import edu.nyu.jet.hmm.HMMstate;
import edu.nyu.jet.hmm.WordFeatureHMMemitter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;

class HMMAugmentor {
    static String originalHMMfile;
    static String newHMMfile;
    static String nameListFile;
    static HashMap<String, TreeSet<String>> stateUnigramTables;
    static HashMap<String, HashSet<String[]>> stateBigramTables;
    static HMMNameTagger tagger;
    static HMM hmm;

    HMMAugmentor() {
    }

    public static void main(String[] args) throws IOException {
        String line;
        if (args.length < 3 || args.length > 4) {
            System.err.println("HMMAugmentor requires 3 or 4 arguments:");
            System.err.println("    base-hmm augmented-hmm name-list [bigram-flag]");
            System.exit(1);
        }
        originalHMMfile = args[0];
        newHMMfile = args[1];
        nameListFile = args[2];
        boolean bigramFlag = args.length > 3;
        BufferedReader reader = new BufferedReader(new FileReader(nameListFile));
        while ((line = reader.readLine()) != null) {
            int i;
            String[] ray = line.split(" \\| ");
            if (ray.length < 2) continue;
            String name = ray[0];
            String type = ray[1];
            String[] tokens = name.split(" ");
            if (type.equals("PERSON") || type.equals("LASTNAME")) {
                if (tokens.length == 1) {
                    HMMAugmentor.addTokenToState(tokens[0], "i-person");
                    continue;
                }
                HMMAugmentor.addTokenToState(tokens[0], "b-person");
                for (i = 1; i < tokens.length - 1; ++i) {
                    HMMAugmentor.addBigramToState(tokens[i - 1], tokens[i], "m-person");
                }
                HMMAugmentor.addBigramToState(tokens[tokens.length - 2], tokens[tokens.length - 1], "e-person");
                continue;
            }
            if (type.equals("COMPANY") || type.equals("ORGANIZATION")) {
                if (tokens.length == 1) {
                    HMMAugmentor.addTokenToState(tokens[0], "i-organization");
                    continue;
                }
                HMMAugmentor.addTokenToState(tokens[0], "b-organization");
                for (i = 1; i < tokens.length - 1; ++i) {
                    HMMAugmentor.addBigramToState(tokens[i - 1], tokens[i], "m-organization");
                }
                HMMAugmentor.addBigramToState(tokens[tokens.length - 2], tokens[tokens.length - 1], "e-organization");
                continue;
            }
            if (type.equals("GPE") || type.equals("CITY")) {
                if (tokens.length == 1) {
                    HMMAugmentor.addTokenToState(tokens[0], "i-gpe");
                    continue;
                }
                HMMAugmentor.addTokenToState(tokens[0], "b-gpe");
                for (i = 1; i < tokens.length - 1; ++i) {
                    HMMAugmentor.addBigramToState(tokens[i - 1], tokens[i], "m-gpe");
                }
                HMMAugmentor.addBigramToState(tokens[tokens.length - 2], tokens[tokens.length - 1], "e-gpe");
                continue;
            }
            System.out.println("Unexpected type:  " + type);
        }
        tagger = new HMMNameTagger(bigramFlag ? BigramHMMemitter.class : WordFeatureHMMemitter.class);
        tagger.load(originalHMMfile);
        hmm = HMMAugmentor.tagger.nameHMM;
        for (String state : stateUnigramTables.keySet()) {
            TreeSet<String> tokenSet = stateUnigramTables.get(state);
            System.out.println("For state " + state + " no of tokens = " + tokenSet.size());
            HMMAugmentor.addUnigramEmitters(state, tokenSet);
        }
        tagger.store(newHMMfile);
    }

    static void addTokenToState(String token, String state) {
        HMMAugmentor.addBigramToState("", token, state);
    }

    static void addBigramToState(String priorToken, String token, String state) {
        TreeSet<String> tokenSet = stateUnigramTables.get(state);
        if (tokenSet == null) {
            tokenSet = new TreeSet();
            stateUnigramTables.put(state, tokenSet);
        }
        tokenSet.add(token);
        HashSet<Object> bigramSet = stateBigramTables.get(state);
        if (bigramSet == null) {
            bigramSet = new HashSet();
            stateBigramTables.put(state, bigramSet);
        }
        String[] pair = new String[]{priorToken, token};
        bigramSet.add(pair);
    }

    static void addUnigramEmitters(String state, TreeSet tokenSet) {
        HMMstate currentState = hmm.getState(state);
        if (currentState == null) {
            System.out.println("Undefined state " + state);
            return;
        }
        for (String token : tokenSet) {
            currentState.incrementEmitCount(token, "", 1);
        }
    }

    static void addBigramEmitters(String state, HashSet bigramSet) {
        HMMstate currentState = hmm.getState(state);
        for (String[] pair : bigramSet) {
            currentState.incrementEmitCount(pair[1], pair[0], 1);
        }
    }

    static {
        stateUnigramTables = new HashMap();
        stateBigramTables = new HashMap();
    }
}

