/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMarc;
import edu.nyu.jet.hmm.HMMemitter;
import edu.nyu.jet.tipster.Annotation;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class HMMstate {
    public String name;
    public String tag;
    private HMM hmm;
    private String featureName;
    private ArrayList allowedFeatureValues;
    HMMemitter emitter;
    HashSet arcset;
    HMMarc[] arcs;
    int count;
    public static double otherPreference = 1.0;

    public HMMstate(String name, String tag, Class emitterClass) {
        this.name = name;
        this.tag = tag;
        this.featureName = null;
        this.allowedFeatureValues = new ArrayList();
        try {
            this.emitter = (HMMemitter)emitterClass.newInstance();
            this.emitter.stateName = name;
        }
        catch (Exception e) {
            System.out.println("Cannot create instance of HMMemitter " + emitterClass);
        }
        this.arcset = new HashSet();
        this.hmm = null;
    }

    public void addArc(HMMarc arc) {
        this.arcset.add(arc);
    }

    public void addArc(String arcName) {
        this.addArc(new HMMarc(arcName, 0));
    }

    public void resolveNames(HashMap statesByName, int nStates) {
        this.arcs = new HMMarc[nStates];
        for (HMMarc arc : this.arcset) {
            arc.resolveTarget(statesByName);
            this.arcs[arc.target] = arc;
        }
    }

    public void setHMM(HMM hmm) {
        this.hmm = hmm;
        this.emitter.hmm = hmm;
    }

    public void resetForTraining() {
        this.count = 0;
        this.emitter.resetForTraining();
        for (HMMarc arc : this.arcset) {
            arc.resetForTraining();
        }
    }

    public void incrementEmitCount(String token, String priorToken, int n) {
        this.emitter.trainOnInstances(token, priorToken, n);
    }

    public void setCacheCount(String tag, int n) {
        this.emitter.setCacheCount(tag, n);
    }

    public void setFeatureName(String s) {
        this.featureName = s;
    }

    public void addAllowedFeatureValue(String s) {
        this.allowedFeatureValues.add(s);
    }

    public boolean allowedToken(Annotation token) {
        if (this.featureName == null) {
            return true;
        }
        return this.allowedFeatureValues.contains(token.get(this.featureName));
    }

    public void computeProbabilities() {
        if (HMM.probReport) {
            System.out.println();
            System.out.println("===== Computing probabilities for " + this.name);
            System.out.println("state count = " + this.count);
        }
        for (HMMarc arc : this.arcset) {
            arc.computeProbabilities(this.count);
        }
        this.emitter.computeProbabilities();
    }

    public void print() {
        System.out.println("STATE " + this.name);
        if (this.tag != "") {
            System.out.println("TAG " + this.tag);
        }
        if (this.featureName != null) {
            System.out.print("FEATURE " + this.featureName);
            for (int i = 0; i < this.allowedFeatureValues.size(); ++i) {
                System.out.print(" " + this.allowedFeatureValues.get(i));
            }
            System.out.println();
        }
        Iterator arcIterator = this.arcset.iterator();
        while (arcIterator.hasNext()) {
            ((HMMarc)arcIterator.next()).print();
        }
        this.emitter.print();
    }

    public void store(PrintWriter stream) {
        stream.println("STATE " + this.name + " " + this.count);
        if (this.tag != "") {
            stream.println("TAG " + this.tag);
        }
        if (this.featureName != null) {
            stream.print("FEATURE " + this.featureName);
            for (int i = 0; i < this.allowedFeatureValues.size(); ++i) {
                stream.print(" " + this.allowedFeatureValues.get(i));
            }
            stream.println();
        }
        Iterator arcIterator = this.arcset.iterator();
        while (arcIterator.hasNext()) {
            ((HMMarc)arcIterator.next()).store(stream);
        }
        this.emitter.store(stream);
    }

    public double getEmissionProb(String tokenText, String priorToken, Annotation token) {
        if (!this.allowedToken(token)) {
            return -1.0E100;
        }
        double p = this.emitter.getProbability(tokenText, priorToken, token.attributes());
        if (this.tag.equals("other")) {
            p += otherPreference;
        }
        return p;
    }

    public double getTransitionProb(int state) {
        HMMarc arc = this.arcs[state];
        if (arc != null) {
            return arc.probability;
        }
        return -1.0E100;
    }
}

