/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.ActiveLearner;
import edu.nyu.jet.hmm.SentenceWithMargin;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationTool;
import edu.nyu.jet.tipster.Document;
import java.util.ArrayList;

class InteractiveAnnotator
extends Thread {
    ArrayList sentencesToAnnotate;

    InteractiveAnnotator(ArrayList sentences) {
        this.sentencesToAnnotate = sentences;
    }

    public void run() {
        for (int isent = 0; isent < this.sentencesToAnnotate.size(); ++isent) {
            SentenceWithMargin swm = (SentenceWithMargin)this.sentencesToAnnotate.get(isent);
            InteractiveAnnotator.annotate(swm.document, swm.sentence);
            if (ActiveLearner.keepLearning) continue;
            return;
        }
    }

    static void annotate(Document doc, Annotation sentence) {
        AnnotationTool tool = new AnnotationTool();
        tool.addType('p', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "PERSON")));
        tool.addType('o', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "ORGANIZATION")));
        tool.addType('g', new Annotation("ENAMEX", null, new FeatureSet("TYPE", "GPE")));
        boolean quit = tool.annotateDocument(doc, sentence.span());
        if (quit) {
            ActiveLearner.keepLearning = false;
        }
        sentence.put("training", "true");
    }
}

