/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.hmm.HMMNameTagger;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class LineByLineNameTagger {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String mtDir = "C:/Documents and Settings/Ralph Grishman/My Documents/GALE/mtTrain/";
    static String propertyFile = "props/mt train tag names.properties";
    static String dataDir = "C:/Documents and Settings/Ralph Grishman/My Documents/GALE/mtTrain/";
    static String outputDir = "C:/Documents and Settings/Ralph Grishman/My Documents/GALE/mtTrain/";
    static String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/GALE/mtTrain/fileList.txt";
    static HMMNameTagger tagger;

    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            if (args.length != 4) {
                System.out.println("TaggedSentenceWriter must have 4 arguments:");
                System.out.println("  propertyFile  filelist  dataDirectory  outputDirectory");
                System.exit(1);
            }
            propertyFile = args[0];
            fileList = args[1];
            dataDir = args[2];
            outputDir = args[3];
        }
        JetTest.initializeFromConfig(propertyFile);
        LineByLineNameTagger.processFileList(fileList);
    }

    private static void processFileList(String fileList) throws IOException {
        String currentDoc;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String sentenceFileName = dataDir + currentDoc;
            String neFileName = outputDir + currentDoc + ".ne";
            LineByLineNameTagger.processFile(sentenceFileName, neFileName);
        }
    }

    private static void processFile(String sentenceFileName, String neFileName) throws IOException {
        String currentSentence;
        BufferedReader reader = new BufferedReader(new FileReader(sentenceFileName));
        PrintWriter writer = new PrintWriter(new FileWriter(neFileName));
        int sentenceCount = 0;
        while ((currentSentence = reader.readLine()) != null) {
            ++sentenceCount;
            String taggedSentence = LineByLineNameTagger.tagSentence(currentSentence);
            writer.println(taggedSentence);
        }
        System.out.println("Tagged " + sentenceCount + " sentences.");
        writer.close();
    }

    private static String tagSentence(String sentence) throws IOException {
        Document doc = new Document(sentence);
        Span sentenceSpan = new Span(0, doc.length());
        Ace.monocase = Ace.allLowerCase(doc, sentenceSpan) || Ace.titleCase(doc, sentenceSpan);
        Control.processDocument(doc, null, false, 0);
        doc.shrink("ENAMEX");
        doc.setSGMLwrapMargin(0);
        return doc.writeSGML("ENAMEX", sentenceSpan).toString();
    }
}

