/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.aceJet.Gazetteer;
import edu.nyu.jet.chunk.Chunker;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.tipster.View;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

class NameCoref {
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/sep02 nwire sgm.txt";
    static final String keyCollection = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/sep02 nwire ne.txt";
    static final String svmInputFile = "C:/Documents and Settings/Ralph Grishman/My Documents/svmlight/training.txt";
    static final String dictFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/EDT type dict.txt";
    static PrintStream writer;

    NameCoref() {
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("ME ace.properties");
        Chunker.loadModel();
        EDTtype.readTypeDict(dictFile);
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/loc.dict");
        Pat.trace = false;
        Resolve.trace = false;
        writer = new PrintStream(new FileOutputStream(svmInputFile));
        NameCoref.processCollection(collection, keyCollection);
        writer.close();
    }

    private static void processCollection(String testCollection, String keyCollection) throws IOException {
        DocumentCollection testCol = new DocumentCollection(testCollection);
        testCol.open();
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        keyCol.open();
        if (testCol.size() != keyCol.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        for (int docCount = 0; docCount < testCol.size(); ++docCount) {
            ExternalDocument testDoc = testCol.get(docCount);
            testDoc.setAllTags(true);
            testDoc.open();
            System.out.println("Processing document " + docCount + " " + testDoc.fileName());
            Ace.monocase = Ace.allLowerCase(testDoc);
            Control.processDocument(testDoc, null, docCount == -1, docCount);
            ExternalDocument keyDoc = keyCol.get(docCount);
            keyDoc.setAllTags(true);
            keyDoc.open();
            new View(testDoc, docCount);
            new View(keyDoc, docCount + 100);
            NameCoref.writeNamedMentions(testDoc, keyDoc);
        }
    }

    private static void writeNamedMentions(Document doc, Document keyDoc) {
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        for (int ientity = 0; ientity < entities.size(); ++ientity) {
            Annotation entity = entities.get(ientity);
            Vector mentions = (Vector)entity.get("mentions");
            int mentionCount = mentions.size();
            for (int imention = 0; imention < mentions.size(); ++imention) {
                Annotation keyEnamex;
                String keyNameType;
                boolean isNameMention;
                Annotation mention = (Annotation)mentions.get(imention);
                Annotation head = Resolve.getHeadC(mention);
                String[] mentionName = Resolve.getNameTokens(doc, mention);
                boolean bl = isNameMention = mentionName != null;
                if (!isNameMention) continue;
                Vector<Annotation> enamexes = doc.annotationsAt(head.start(), "ENAMEX");
                if (enamexes == null || enamexes.size() == 0) {
                    System.out.println("Name mention with no enamex.");
                    return;
                }
                Annotation enamex = enamexes.get(0);
                int nameStart = enamex.start();
                String nameType = (String)enamex.get("type");
                Integer margin = (Integer)enamex.get("margin");
                Span span = enamex.span();
                Vector<Annotation> keyEnamexes = keyDoc.annotationsAt(nameStart, "ENAMEX");
                boolean match = false;
                if (keyEnamexes != null && keyEnamexes.size() > 0 && nameType.equalsIgnoreCase(keyNameType = (String)(keyEnamex = keyEnamexes.get(0)).get("TYPE")) && span.equals(keyEnamex.span())) {
                    match = true;
                }
                System.out.println("\"" + Resolve.concat(mentionName) + "\" " + span + " type:" + nameType + " margin:" + margin + " firstMention:" + (imention == 0) + " mentionCount:" + mentionCount + " " + match);
                writer.println((match ? 1 : -1) + " 1:" + margin + " 2:" + (imention == 0 ? 1 : 0) + " 3:" + mentionCount);
            }
        }
    }
}

