/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.hmm;

import edu.nyu.jet.hmm.HMM;
import edu.nyu.jet.hmm.HMMemitter;
import edu.nyu.jet.lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SuffixHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 5000.0f;
    private static final int suffixLength = 3;
    private static final double threshold = 10.0;
    static int allStateCount = 0;
    static HashMap suffixCount = new HashMap();
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    HashMap LCtokenCount;
    HashMap LCtokenProbability;
    HashMap featureCount;
    HashMap featureProbability;
    HashMap cacheCount;
    HashMap stateSuffixCount;
    HashMap stateSuffixTokens;
    HashMap suffixProbability;
    double[] inCacheProbability;
    double[] notInCacheProbability;
    double lambda;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
        this.LCtokenCount = new HashMap();
        this.featureCount = new HashMap();
        this.cacheCount = new HashMap();
        this.stateSuffixCount = new HashMap();
        this.stateSuffixTokens = new HashMap();
    }

    public void setCacheCount(String type, int n) {
        this.cacheCount.put(type, new Integer(n));
    }

    public void trainOnInstances(String token, String priorToken, int n) {
        this.count += n;
        allStateCount += n;
        SuffixHMMemitter.incrementHashMap(this.tokenCount, token, n);
        SuffixHMMemitter.incrementHashMap(this.LCtokenCount, token.toLowerCase(), n);
        SuffixHMMemitter.incrementHashMap(this.featureCount, SuffixHMMemitter.wordFeature(token), n);
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                if (!this.hmm.inCache(token, this.hmm.tagsToCache[i])) continue;
                SuffixHMMemitter.incrementHashMap(this.cacheCount, this.hmm.tagsToCache[i], 1);
            }
        }
        if (token.length() > 3) {
            String suffix = token.substring(token.length() - 3);
            SuffixHMMemitter.incrementHashMap(suffixCount, suffix, n);
            SuffixHMMemitter.incrementHashMap(this.stateSuffixCount, suffix, n);
            HashSet<String> h = (HashSet<String>)this.stateSuffixTokens.get(suffix);
            if (h == null) {
                h = new HashSet<String>();
            }
            h.add(token);
            this.stateSuffixTokens.put(suffix, h);
        }
    }

    public void computeProbabilities() {
        Integer c2;
        this.tokenProbability = new HashMap();
        int singletonCount = 0;
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String token = (String)entry.getKey();
            int tokenCount = (Integer)entry.getValue();
            double probability = Math.log((double)tokenCount / (double)this.count);
            this.tokenProbability.put(token, new Double(probability));
            if (tokenCount != 1) continue;
            ++singletonCount;
        }
        this.LCtokenProbability = new HashMap();
        for (Map.Entry entry : this.LCtokenCount.entrySet()) {
            String LCtoken = (String)entry.getKey();
            int LCtokenCount = (Integer)entry.getValue();
            double probability = Math.log((double)LCtokenCount / (double)this.count);
            this.LCtokenProbability.put(LCtoken, new Double(probability));
        }
        this.featureProbability = new HashMap();
        for (Map.Entry entry : this.featureCount.entrySet()) {
            String feature = (String)entry.getKey();
            int featureCount = (Integer)entry.getValue();
            double probability = Math.log((double)featureCount / (double)this.count);
            this.featureProbability.put(feature, new Double(probability));
        }
        Integer c1 = (Integer)this.featureCount.get("initCap");
        int c3 = (c1 == null ? 0 : c1) + ((c2 = (Integer)this.featureCount.get("lowerCase")) == null ? 0 : c2);
        if (c3 != 0) {
            double pfc = Math.log((double)c3 / (double)this.count);
            this.featureProbability.put("forcedCap", new Double(pfc));
        }
        this.suffixProbability = new HashMap();
        for (Map.Entry entry : suffixCount.entrySet()) {
            double pfactor;
            String suffix = (String)entry.getKey();
            int suffixCt = (Integer)entry.getValue();
            HashSet h = (HashSet)this.stateSuffixTokens.get(suffix);
            int stateSuffixTypes = h == null ? 0 : h.size();
            Integer ssc = (Integer)this.stateSuffixCount.get(suffix);
            int stateSuffixCt = ssc == null ? 0 : ssc;
            double expected = suffixCt * this.count / allStateCount;
            if (stateSuffixTypes <= 5 || !((pfactor = Math.log((double)(stateSuffixCt + 2) / (expected + 2.0))) > 0.0)) continue;
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName + " pfactor(" + suffix + ") = " + pfactor + "tokens=" + h);
            }
            this.suffixProbability.put(suffix, new Double(pfactor));
        }
        this.lambda = 1.0 / (1.0 + (double)this.tokenCount.size() / (double)this.count);
        this.unseenTokenProbability = Math.log((double)singletonCount / (double)this.count / 5000.0);
        if (this.hmm.tagsToCache != null) {
            this.inCacheProbability = new double[this.hmm.tagsToCache.length];
            this.notInCacheProbability = new double[this.hmm.tagsToCache.length];
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName);
            }
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                int cc;
                Integer cacheCt = (Integer)this.cacheCount.get(this.hmm.tagsToCache[i]);
                int n = cc = cacheCt == null ? 0 : cacheCt;
                if (HMM.probReport) {
                    System.out.println("Cache count[" + this.hmm.tagsToCache[i] + "]=" + cc);
                    System.out.println("inCacheProbability[" + this.hmm.tagsToCache[i] + "]=" + (double)cc / (double)this.count);
                }
                this.inCacheProbability[i] = Math.log((double)cc / (double)this.count);
                this.notInCacheProbability[i] = Math.log(1.0 - (double)cc / (double)this.count);
            }
        }
    }

    public double getProbability(String token, String priorToken, FeatureSet fs) {
        String suffix;
        Double sp;
        double prob;
        double unseenFeatureProbability = -8.0;
        boolean forcedCap = fs.get("case") == "forcedCap";
        Double tprob = forcedCap ? (Double)this.LCtokenProbability.get(token.toLowerCase()) : (Double)this.tokenProbability.get(token);
        if (tprob != null) {
            prob = tprob;
        } else {
            Double fprob;
            String tokenForm = SuffixHMMemitter.wordFeature(token);
            if (forcedCap && tokenForm == "initCap") {
                tokenForm = "forcedCap";
            }
            prob = (fprob = (Double)this.featureProbability.get(tokenForm)) != null ? this.unseenTokenProbability + fprob : this.unseenTokenProbability + unseenFeatureProbability;
        }
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                String tag = this.hmm.tagsToCache[i];
                boolean inCache = this.hmm.inCache(token, tag);
                if (inCache) {
                    prob += this.inCacheProbability[i];
                    continue;
                }
                prob += this.notInCacheProbability[i];
            }
        }
        if (token.length() > 3 && (sp = (Double)this.suffixProbability.get(suffix = token.substring(token.length() - 3))) != null) {
            prob += sp.doubleValue();
        }
        return prob;
    }

    public void print() {
        for (Map.Entry entry : this.featureProbability.entrySet()) {
            String token = (String)entry.getKey();
            double probability = (Double)entry.getValue();
            System.out.println("EMIT " + token + " " + probability);
        }
    }

    public void store(PrintWriter stream) {
        for (Map.Entry entry : this.tokenCount.entrySet()) {
            String token = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            stream.println("EMIT " + token + " " + count);
        }
        for (Map.Entry entry : this.cacheCount.entrySet()) {
            String type = (String)entry.getKey();
            int count = (Integer)entry.getValue();
            stream.println("PREVTAGGED " + type + " " + count);
        }
    }

    static String wordFeature(String word) {
        int len = word.length();
        boolean allDigits = true;
        boolean allCaps = true;
        boolean initCap = true;
        boolean allLower = true;
        boolean hyphenated = true;
        for (int i = 0; i < len; ++i) {
            char c = word.charAt(i);
            if (!Character.isDigit(c)) {
                allDigits = false;
            }
            if (!Character.isUpperCase(c)) {
                allCaps = false;
            }
            if (!Character.isLowerCase(c)) {
                allLower = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                hyphenated = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            initCap = false;
        }
        if (allDigits) {
            if (len == 2) {
                return "twoDigitNum";
            }
            if (len == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (allCaps) {
            return "allCaps";
        }
        if (initCap) {
            return "initCap";
        }
        if (allLower) {
            return "lowerCase";
        }
        if (hyphenated) {
            return "hyphenated";
        }
        return "other";
    }

    private static void incrementHashMap(HashMap map, String key, int n) {
        Integer countI = (Integer)map.get(key);
        int count = countI == null ? 0 : countI;
        map.put(key, new Integer(count + n));
    }
}

