/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.lex;

import edu.nyu.jet.lex.Lexicon;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.pat.PatternSyntaxError;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class EnglishLex {
    public static void readLexicon(String fileName) throws IOException {
        System.err.println("Reading lexicon " + fileName);
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        LineNumberReader lnreader = new LineNumberReader(reader);
        StreamTokenizer tok = new StreamTokenizer(lnreader);
        int definitionCounter = 0;
        while (tok.nextToken() != -1) {
            try {
                EnglishLex.readLexiconDefinition(tok);
                ++definitionCounter;
            }
            catch (PatternSyntaxError pse) {
                int ln = lnreader.getLineNumber();
                System.err.println("*** syntax error in lexicon, line " + ln);
                System.err.println(pse.toString());
                if (tok.ttype == -3) {
                    System.err.println("Current token = " + tok.sval);
                } else {
                    System.err.println("Current token = " + (char)tok.ttype);
                }
                while (tok.nextToken() != 59) {
                    if (tok.ttype != -1) continue;
                    return;
                }
            }
        }
        System.err.println(definitionCounter + " lexical entries read");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void readLexiconDefinition(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        String[] words;
        Vector<String> lexItem = new Vector<String>();
        if (tok.ttype == -3) {
            do {
                lexItem.addElement(tok.sval);
            } while (tok.nextToken() == -3);
            words = lexItem.toArray(new String[0]);
        } else {
            if (tok.ttype != 34) throw new PatternSyntaxError();
            words = Tokenizer.tokenize(tok.sval);
            tok.nextToken();
        }
        if (tok.ttype == 59) {
            return;
        }
        if (tok.ttype != 44) {
            throw new PatternSyntaxError(", expected");
        }
        if (tok.nextToken() == -3) {
            String entryType = tok.sval;
            if (tok.nextToken() == 44) {
                FeatureSet fs = new FeatureSet(tok, false, ';');
                EnglishLex.defineEnglishEntry(words, entryType, fs);
                return;
            }
            if (tok.ttype == 59) {
                EnglishLex.defineEnglishEntry(words, entryType, new FeatureSet());
                return;
            }
            System.err.println("In defn of " + words[0].toString());
            throw new PatternSyntaxError(", or ; expected");
        }
        if (tok.ttype == 44) {
            FeatureSet fs = new FeatureSet(tok, false, ';');
            Lexicon.addEntry(words, fs);
            return;
        }
        if (tok.ttype != 59) throw new PatternSyntaxError("entry type expected");
    }

    private static void defineEnglishEntry(String[] words, String entryType, FeatureSet fs) throws PatternSyntaxError {
        if (entryType.equals("noun")) {
            EnglishLex.defineEnglishNoun(words, fs);
        } else if (entryType.equals("verb")) {
            EnglishLex.defineEnglishVerb(words, fs);
        } else if (entryType.equals("adj")) {
            EnglishLex.defineEnglishAdjective(words, fs);
        } else if (entryType.equals("adv")) {
            EnglishLex.defineEnglishAdverb(words, fs);
        } else if (entryType.equals("name")) {
            EnglishLex.defineEnglishName(words, fs);
        } else {
            throw new PatternSyntaxError("unknown entry type");
        }
    }

    private static void defineEnglishNoun(String[] words, FeatureSet fs) {
        String[] pluralWords;
        String plural = EnglishLex.makeString(fs.get("plural"));
        FeatureSet attributes = (FeatureSet)fs.get("attributes");
        String xn = EnglishLex.makeString(fs.get("xn"));
        String pred = xn == null ? EnglishLex.fuseWithUnderscores(words) : xn;
        FeatureSet singularDefn = new FeatureSet("cat", "n", "number", "singular", "pa", new FeatureSet("head", pred, "number", "singular"));
        singularDefn.putAll(attributes);
        Lexicon.addEntry(words, singularDefn);
        if (plural == null) {
            pluralWords = EnglishLex.nounPlural(words);
        } else {
            if (plural.equals("none")) {
                return;
            }
            pluralWords = Tokenizer.tokenize(plural);
        }
        FeatureSet pluralDefn = new FeatureSet("cat", "n", "number", "plural", "pa", new FeatureSet("head", pred, "number", "plural"));
        pluralDefn.putAll(attributes);
        Lexicon.addEntry(pluralWords, pluralDefn);
    }

    private static String makeString(Object ob) {
        if (ob == null) {
            return null;
        }
        return ob.toString();
    }

    private static void defineEnglishVerb(String[] words, FeatureSet fs) {
        String thirdSing = EnglishLex.makeString(fs.get("thirdSing"));
        String plural = EnglishLex.makeString(fs.get("plural"));
        String past = EnglishLex.makeString(fs.get("past"));
        String pastPart = EnglishLex.makeString(fs.get("pastPart"));
        String presPart = EnglishLex.makeString(fs.get("presPart"));
        FeatureSet attributes = (FeatureSet)fs.get("attributes");
        String xn = (String)fs.get("xn");
        String pred = xn == null ? EnglishLex.fuseWithUnderscores(words) : xn;
        FeatureSet infinitiveDefn = new FeatureSet("cat", "v", "pa", new FeatureSet("head", pred));
        infinitiveDefn.putAll(attributes);
        Lexicon.addEntry(words, infinitiveDefn);
        FeatureSet thirdSingDefn = new FeatureSet("cat", "tv", "number", "singular", "pa", new FeatureSet("head", pred, "tense", "present"));
        thirdSingDefn.putAll(attributes);
        if (thirdSing == null) {
            Lexicon.addEntry(EnglishLex.nounPlural(words), thirdSingDefn);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(thirdSing), thirdSingDefn);
        }
        FeatureSet pluralDefn = new FeatureSet("cat", "tv", "number", "plural", "pa", new FeatureSet("head", pred, "tense", "present"));
        pluralDefn.putAll(attributes);
        if (plural == null) {
            Lexicon.addEntry(words, pluralDefn);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(plural), pluralDefn);
        }
        FeatureSet pastDefn = new FeatureSet("cat", "tv", "pa", new FeatureSet("head", pred, "tense", "past"));
        pastDefn.putAll(attributes);
        if (past == null) {
            Lexicon.addEntry(EnglishLex.verbPast(words), pastDefn);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(past), pastDefn);
        }
        FeatureSet presPartDefn = new FeatureSet("cat", "ving", "pa", new FeatureSet("head", pred));
        presPartDefn.putAll(attributes);
        if (presPart == null) {
            Lexicon.addEntry(EnglishLex.verbPresPart(words), presPartDefn);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(presPart), presPartDefn);
        }
        FeatureSet pastPartDefn = new FeatureSet("cat", "ven", "pa", new FeatureSet("head", pred));
        pastPartDefn.putAll(attributes);
        if (pastPart == null) {
            Lexicon.addEntry(EnglishLex.verbPast(words), pastPartDefn);
        } else {
            Lexicon.addEntry(Tokenizer.tokenize(pastPart), pastPartDefn);
        }
    }

    private static void defineEnglishAdjective(String[] words, FeatureSet fs) {
        FeatureSet attributes = (FeatureSet)fs.get("attributes");
        String pred = EnglishLex.fuseWithUnderscores(words);
        FeatureSet adjectiveDefn = new FeatureSet("cat", "adj", "pa", new FeatureSet("head", pred));
        adjectiveDefn.putAll(attributes);
        Lexicon.addEntry(words, adjectiveDefn);
    }

    private static void defineEnglishAdverb(String[] words, FeatureSet fs) {
        FeatureSet attributes = (FeatureSet)fs.get("attributes");
        String pred = EnglishLex.fuseWithUnderscores(words);
        FeatureSet adverbDefn = new FeatureSet("cat", "adv", "pa", new FeatureSet("head", pred));
        adverbDefn.putAll(attributes);
        Lexicon.addEntry(words, adverbDefn);
    }

    private static void defineEnglishName(String[] words, FeatureSet fs) {
        String nameClass = (String)fs.get("class");
        FeatureSet nameDefn = new FeatureSet("cat", "name");
        if (nameClass != null) {
            nameDefn.put("class", nameClass);
        }
        Lexicon.addEntry(words, nameDefn);
    }

    private static String fuseWithUnderscores(String[] words) {
        String result = words[0];
        for (int i = 1; i < words.length; ++i) {
            result = result + "_" + words[i];
        }
        return result;
    }

    public static String[] nounPlural(String[] words) {
        int nextToLast;
        String[] result = new String[words.length];
        for (int i = 0; i < words.length - 1; ++i) {
            result[i] = words[i];
        }
        String lastword = words[words.length - 1];
        int len = lastword.length();
        char lastChar = lastword.charAt(len - 1);
        int n = nextToLast = lastword.length() > 1 ? (int)lastword.charAt(len - 2) : 32;
        String pluralForm = lastChar == 's' || lastChar == 'z' || lastChar == 'x' || (nextToLast == 99 || nextToLast == 115) && lastChar == 'h' ? lastword + "es" : (lastChar == 'y' ? (nextToLast == 97 || nextToLast == 101 || nextToLast == 105 || nextToLast == 111 || nextToLast == 121 ? lastword + "s" : lastword.substring(0, len - 1) + "ies") : lastword + "s");
        result[words.length - 1] = pluralForm;
        return result;
    }

    private static String[] verbPast(String[] words) {
        int nextToLast;
        String[] result = new String[words.length];
        for (int i = 0; i < words.length - 1; ++i) {
            result[i] = words[i];
        }
        String lastword = words[words.length - 1];
        int len = lastword.length();
        char lastChar = lastword.charAt(len - 1);
        int n = nextToLast = lastword.length() > 1 ? (int)lastword.charAt(len - 2) : 32;
        String pastForm = lastChar == 'e' ? lastword + "d" : (lastChar == 'y' ? (nextToLast == 97 || nextToLast == 101 || nextToLast == 105 || nextToLast == 111 || nextToLast == 121 ? lastword + "ed" : lastword.substring(0, len - 1) + "ied") : lastword + "ed");
        result[words.length - 1] = pastForm;
        return result;
    }

    private static String[] verbPresPart(String[] words) {
        String[] result = new String[words.length];
        for (int i = 0; i < words.length - 1; ++i) {
            result[i] = words[i];
        }
        String lastword = words[words.length - 1];
        int len = lastword.length();
        char lastChar = lastword.charAt(len - 1);
        String presPartForm = lastChar == 'e' ? lastword.substring(0, len - 1) + "ing" : lastword + "ing";
        result[words.length - 1] = presPartForm;
        return result;
    }
}

