/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.lex;

import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.Vector;

public class LexicalEntry {
    String[] words;
    Vector definitions;
    String type = "constit";

    public LexicalEntry(String[] wds, FeatureSet fs) {
        this.words = wds;
        this.definitions = new Vector();
        this.definitions.addElement(fs);
    }

    public LexicalEntry(String[] wds, FeatureSet fs, String type) {
        this.words = wds;
        this.definitions = new Vector();
        this.definitions.addElement(fs);
        this.type = type;
    }

    public void addDefinition(FeatureSet fs) {
        this.definitions.addElement(fs);
    }

    public FeatureSet[] getDefinition() {
        return this.definitions.toArray(new FeatureSet[0]);
    }

    public boolean matches(String[] wds) {
        if (this.words.length == wds.length) {
            for (int i = 0; i < this.words.length; ++i) {
                if (this.words[i].equals(wds[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int matches(Document doc, int posn) {
        for (int i = 0; i < this.words.length; ++i) {
            boolean forcedCap;
            Annotation ann = doc.tokenAt(posn);
            if (ann == null) {
                return 0;
            }
            String token = doc.text(ann).trim();
            boolean bl = forcedCap = ann.get("case") == "forcedCap" || Ace.monocase;
            if (forcedCap ? !token.equalsIgnoreCase(this.words[i]) : !token.equals(this.words[i])) {
                return 0;
            }
            posn = ann.span().end();
        }
        return posn;
    }
}

