/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.ClassAnnotator;
import edu.nyu.jet.ne.ClassHierarchyResolver;
import edu.nyu.jet.ne.Dictionary;
import edu.nyu.jet.ne.DictionaryTagger;
import edu.nyu.jet.ne.NamedEntityUtil;
import edu.nyu.jet.ne.RuleFormatException;
import edu.nyu.jet.ne.SimpleClassHierarchyResolver;
import edu.nyu.jet.ne.TransformRules;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameAnnotator {
    private static final String systemName = "ENE";
    private DictionaryTagger dictTagger = new DictionaryTagger();
    private TransformRules rules;
    private ClassAnnotator classAnnotator;
    private ClassHierarchyResolver hierarchyResolver;
    private Map<String, String> aliasTable;

    public void setDictionary(Dictionary dict) {
        this.dictTagger.setDictionary(dict);
    }

    public void loadClassDictionary(Reader in) throws IOException {
        this.classAnnotator = new ClassAnnotator(in);
    }

    public void loadClassDictionary(File file) throws IOException {
        this.classAnnotator = new ClassAnnotator(file);
    }

    public void loadRules(Reader in) throws IOException, RuleFormatException {
        this.rules = TransformRules.load(in);
        if (this.hierarchyResolver != null) {
            this.rules.setClassHierarchyResolver(this.hierarchyResolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRules(File file) throws IOException, RuleFormatException {
        FileReader in = null;
        try {
            in = new FileReader(file);
            this.loadRules(in);
        }
        finally {
            if (in != null) {
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void annotate(Document doc, Span span) {
        NamedEntityUtil.splitToNamedEntity(doc, span);
        this.dictTagger.annotate(doc, span);
        if (this.classAnnotator != null) {
            this.classAnnotator.annotate(doc, span);
        }
        this.rules.apply(doc, span);
        NamedEntityUtil.packNamedEntity(doc, span, systemName);
        if (this.aliasTable != null) {
            Vector<Annotation> neList = doc.annotationsOfType("ENAMEX", span);
            for (Annotation name : neList) {
                String type = (String)name.get("TYPE");
                String alias = this.aliasTable.get(type);
                if (alias != null) {
                    name.put("TYPE", alias);
                    continue;
                }
                doc.removeAnnotation(name);
            }
        }
    }

    public void annotate(Document doc) {
        this.annotate(doc, doc.fullSpan());
    }

    public void setAliasMap(Map<String, String> map) {
        this.aliasTable = map;
    }

    public void loadClassHierarchy(File file) throws IOException {
        this.hierarchyResolver = SimpleClassHierarchyResolver.getInstance(file);
        if (this.rules != null) {
            this.rules.setClassHierarchyResolver(this.hierarchyResolver);
        }
    }
}

