/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.Dictionary;
import edu.nyu.jet.ne.DictionaryFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OnMemoryDictionary
extends Dictionary {
    private Map<List<String>, Set<String>> dict = new HashMap<List<String>, Set<String>>();
    private String[] tokens;
    private int maxWordCount = 0;

    public void load(File file) throws IOException, DictionaryFormatException {
        FileReader in = new FileReader(file);
        this.load(in);
    }

    public void load(Reader in) throws IOException, DictionaryFormatException {
        BufferedReader bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        String line = null;
        int lineno = 1;
        while ((line = bin.readLine()) != null) {
            String[] parts = line.split("\\s+/\\s+", 2);
            if (parts.length != 2) {
                throw new DictionaryFormatException("format error at " + lineno);
            }
            String key = parts[0].replaceAll("\\\\/", "/");
            List<String> words = Arrays.asList(key.split("\\s+"));
            String cls = parts[1].intern();
            for (int i = 0; i < words.size(); ++i) {
                words.set(i, words.get(i).intern());
            }
            Set<String> set = this.dict.get(words);
            if (set == null) {
                set = new HashSet<String>();
                set.add(cls);
                this.dict.put(words, set);
            } else {
                set.add(cls);
            }
            if (words.size() > this.maxWordCount) {
                this.maxWordCount = words.size();
            }
            ++lineno;
        }
    }

    public void lookupStart(String[] tokens) {
        this.tokens = tokens;
    }

    public Dictionary.Entry lookup(int pos) {
        int i;
        int length = Math.min(this.maxWordCount, this.tokens.length - pos);
        ArrayList<String> key = new ArrayList<String>();
        int keyLength = 0;
        Set<String> foundValue = null;
        for (i = 0; i < length; ++i) {
            key.add(this.tokens[pos + i]);
            Set<String> value = this.dict.get(key);
            if (value == null) continue;
            foundValue = value;
            keyLength = i + 1;
        }
        if (foundValue != null) {
            for (i = key.size() - 1; i >= keyLength; --i) {
                key.remove(i);
            }
            return new Dictionary.Entry(key.size(), foundValue);
        }
        return null;
    }
}

