/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.MatchType;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.regex.Pattern;

public class RegexpRule {
    private MatchType matchType;
    private Pattern pattern;

    public RegexpRule(MatchType type, String pattern) {
        this.matchType = type;
        this.pattern = Pattern.compile(pattern);
    }

    public boolean accept(Document doc, Annotation[] tokens, int pos) {
        boolean ret;
        if (this.matchType == MatchType.ANY) {
            return true;
        }
        String token = doc.normalizedText(tokens[pos]);
        boolean matched = this.pattern.matcher(token).matches();
        switch (this.matchType) {
            case NORMAL: {
                ret = matched;
                break;
            }
            case NOT: {
                ret = !matched;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        return ret;
    }
}

