/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.ClassHierarchyResolver;
import edu.nyu.jet.util.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleClassHierarchyResolver
implements ClassHierarchyResolver {
    private Map<String, Set<String>> subClassMap = new HashMap<String, Set<String>>();

    private SimpleClassHierarchyResolver(Map<String, Set<String>> subClassMap) {
        this.subClassMap = subClassMap;
    }

    @Override
    public boolean isSubClassOf(String target, String className) {
        if (className == target || className.equals(target)) {
            return true;
        }
        Set<String> entry = this.subClassMap.get(className);
        if (entry == null) {
            return false;
        }
        return entry.contains(target);
    }

    public static ClassHierarchyResolver getInstance(Reader in) throws IOException {
        if (in instanceof BufferedReader) {
            return SimpleClassHierarchyResolver.getInstance((BufferedReader)in);
        }
        return SimpleClassHierarchyResolver.getInstance(new BufferedReader(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassHierarchyResolver getInstance(File file) throws IOException {
        ClassHierarchyResolver classHierarchyResolver;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            classHierarchyResolver = SimpleClassHierarchyResolver.getInstance(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly(in);
        return classHierarchyResolver;
    }

    private static ClassHierarchyResolver getInstance(BufferedReader in) throws IOException {
        String line;
        Stack stack = new Stack();
        HashMap<String, Set<String>> subClassMap = new HashMap<String, Set<String>>();
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String name = line.trim().intern();
            int level = SimpleClassHierarchyResolver.countHeadingSpace(line);
            if (subClassMap.containsKey(name)) {
                throw new RuntimeException(name + " appeared twice.");
            }
            if (level > stack.size()) {
                throw new RuntimeException("invalid indent");
            }
            while (stack.size() > level) {
                stack.pop();
            }
            HashSet newEntry = new HashSet();
            subClassMap.put(name, newEntry);
            stack.push(newEntry);
            for (Set set : stack) {
                set.add(name);
            }
        }
        return new SimpleClassHierarchyResolver(subClassMap);
    }

    private static int countHeadingSpace(String str) {
        int i;
        for (i = 0; i < str.length() && Character.isWhitespace(str.charAt(i)); ++i) {
        }
        return i;
    }
}

