/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.ne;

import edu.nyu.jet.ne.BioType;
import edu.nyu.jet.ne.ChangeRule;
import edu.nyu.jet.ne.ChangeType;
import edu.nyu.jet.ne.ClassRule;
import edu.nyu.jet.ne.MatchRuleItem;
import edu.nyu.jet.ne.MatchType;
import edu.nyu.jet.ne.NamedEntityAttribute;
import edu.nyu.jet.ne.NamedEntityRule;
import edu.nyu.jet.ne.PartOfSpeechRule;
import edu.nyu.jet.ne.RegexpRule;
import edu.nyu.jet.ne.RuleFormatException;
import edu.nyu.jet.ne.StringRule;
import edu.nyu.jet.ne.TransformRule;
import edu.nyu.jet.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformRuleParser {
    private static final char PREFIX_CHANGE_FORCE = '!';
    private static final char PREFIX_MATCH_NOT = '!';
    private static final char PREFIX_MATCH_SPECIAL = '~';
    private static final Pattern MATCH_RULE_SEPARATOR = Pattern.compile("\\s+");
    private static final Pattern PATTERN_SEPARATOR = Pattern.compile("\\|");
    private static final int OFFSET_STRING_MATCH_RULE = 0;
    private static final int OFFSET_CLASS_MATCH_RULE = 1;
    private static final int OFFSET_POS_MATCH_RULE = 2;
    private static final int OFFSET_NE_MATCH_RULE = 3;
    private static final int OFFSET_RE_MATCH_RULE = 4;
    private static final String PREFIX_NE_BIO_B = "B-";
    private static final String PREFIX_NE_BIO_I = "I-";
    private static final String NE_BIO_O = "O";

    public List<TransformRule> parse(Reader in) throws IOException, RuleFormatException {
        String line;
        BufferedReader bin = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        ArrayList<TransformRule> rules = new ArrayList<TransformRule>();
        while ((line = bin.readLine()) != null) {
            int pos = line.indexOf(35);
            if (pos >= 0) {
                line = line.substring(0, pos);
            }
            if ((line = line.trim()).length() <= 0) continue;
            rules.add(this.parseLine(line));
        }
        return rules;
    }

    private TransformRule parseLine(String line) throws RuleFormatException {
        int pos = line.indexOf(62);
        if (pos < 0) {
            throw new RuleFormatException("change rule not.");
        }
        String pattern = line.substring(0, pos).trim();
        String change = line.substring(pos + 1).trim();
        ChangeType changeType = ChangeType.NORMAL;
        if (change.charAt(0) == '!') {
            changeType = ChangeType.FORCE;
            change = change.substring(1).trim();
        }
        TransformRule rule = new TransformRule();
        rule.setMatchRules(this.parseMatchRule(pattern));
        rule.setChangeRule(changeType, this.parseChangeRule(change));
        return rule;
    }

    private MatchRuleItem[] parseMatchRule(String pattern) throws RuleFormatException {
        Pattern regex = Pattern.compile("\\s*\\((.*?)\\)\\s*");
        Matcher matcher = regex.matcher(pattern);
        ArrayList<String> elements = new ArrayList<String>();
        while (matcher.regionStart() < pattern.length()) {
            if (!matcher.lookingAt()) {
                throw new RuleFormatException("Ilegral matching rule.");
            }
            elements.add(matcher.group(1));
            matcher.region(matcher.end(), matcher.regionEnd());
        }
        MatchRuleItem[] rule = new MatchRuleItem[elements.size()];
        int len = elements.size();
        for (int i = 0; i < len; ++i) {
            rule[i] = this.parseMatchRuleItem((String)elements.get(i));
        }
        return rule;
    }

    private ChangeRule[] parseChangeRule(String change) throws RuleFormatException {
        String[] items = change.split("\\s+");
        ChangeRule[] rules = new ChangeRule[items.length];
        for (int i = 0; i < items.length; ++i) {
            int changePos;
            int pos = items[i].indexOf(61);
            if (pos < 0) {
                throw new RuleFormatException();
            }
            String numStr = items[i].substring(0, pos).trim();
            try {
                changePos = Integer.parseInt(numStr) - 1;
            }
            catch (NumberFormatException ex) {
                throw new RuleFormatException('\"' + numStr + "\" is not number");
            }
            if (changePos < 0) {
                throw new RuleFormatException('\"' + numStr + "\" is invalid number");
            }
            String neStr = items[i].substring(pos + 1).trim();
            NamedEntityAttribute ne = this.parseNamedEntityExpression(neStr);
            rules[i] = new ChangeRule(changePos, ne);
        }
        return rules;
    }

    private MatchRuleItem parseMatchRuleItem(String itemString) throws RuleFormatException {
        String[] items = MATCH_RULE_SEPARATOR.split(itemString);
        MatchRuleItem rule = new MatchRuleItem();
        block11: for (int i = 0; i < items.length; ++i) {
            MatchType matchType;
            if (items[i].equals("*")) continue;
            if (items[i].length() == 0) {
                throw new RuleFormatException();
            }
            String item = items[i];
            switch (item.charAt(0)) {
                case '!': {
                    item = item.substring(1);
                    matchType = MatchType.NOT;
                    break;
                }
                case '~': {
                    item = item.substring(1);
                    matchType = MatchType.SPECIAL;
                    break;
                }
                default: {
                    matchType = MatchType.NORMAL;
                }
            }
            String[] array = PATTERN_SEPARATOR.split(item);
            switch (i) {
                case 0: {
                    rule.setStringRule(this.parseStringRule(matchType, array));
                    continue block11;
                }
                case 1: {
                    rule.setClassRule(this.parseClassRule(matchType, array));
                    continue block11;
                }
                case 2: {
                    rule.setPartOfSpeechRule(this.parsePartOfSpeechRule(matchType, array));
                    continue block11;
                }
                case 3: {
                    rule.setNamedEntityRule(this.parseNamedEntityRule(matchType, array));
                    continue block11;
                }
                case 4: {
                    rule.setRegexpRule(this.parseRegexpRule(matchType, array));
                    continue block11;
                }
                default: {
                    throw new RuleFormatException();
                }
            }
        }
        return rule;
    }

    private StringRule parseStringRule(MatchType type, String[] pattern) throws RuleFormatException {
        switch (type) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new StringRule(type, pattern);
            }
        }
        throw new RuleFormatException();
    }

    private ClassRule parseClassRule(MatchType type, String[] pattern) throws RuleFormatException {
        for (int i = 0; i < pattern.length; ++i) {
            if (!pattern[i].startsWith("N-")) continue;
            pattern[i] = pattern[i].substring(2);
        }
        switch (type) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new ClassRule(type, pattern);
            }
            case SPECIAL: {
                if (pattern.length == 1) {
                    return new ClassRule(type, pattern);
                }
                throw new RuleFormatException();
            }
        }
        throw new RuleFormatException();
    }

    private PartOfSpeechRule parsePartOfSpeechRule(MatchType type, String[] pattern) throws RuleFormatException {
        switch (type) {
            case NORMAL: 
            case NOT: 
            case ANY: {
                return new PartOfSpeechRule(type, pattern);
            }
        }
        throw new RuleFormatException();
    }

    private NamedEntityRule parseNamedEntityRule(MatchType type, String[] pattern) throws RuleFormatException {
        NamedEntityAttribute[] attrs = new NamedEntityAttribute[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            attrs[i] = this.parseNamedEntityExpression(pattern[i]);
        }
        return new NamedEntityRule(type, attrs);
    }

    private RegexpRule parseRegexpRule(MatchType type, String[] pattern) throws RuleFormatException {
        return new RegexpRule(type, StringUtils.join("|", pattern));
    }

    private NamedEntityAttribute parseNamedEntityExpression(String str) throws RuleFormatException {
        if (str.equals(NE_BIO_O)) {
            return new NamedEntityAttribute(null, BioType.O);
        }
        if (str.startsWith(PREFIX_NE_BIO_B)) {
            String ne = str.substring(PREFIX_NE_BIO_B.length());
            return new NamedEntityAttribute(ne, BioType.B);
        }
        if (str.startsWith(PREFIX_NE_BIO_I)) {
            String ne = str.substring(PREFIX_NE_BIO_I.length());
            return new NamedEntityAttribute(ne, BioType.I);
        }
        throw new RuleFormatException('\"' + str + "\" is not named entity name");
    }
}

