/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.SynFun;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Vector;

public class AddSyntacticRelations {
    public static final String[] prepositions = new String[]{"of", "on", "in", "to", "by", "at", "through", "for", "with"};
    public static final String[] comlexDeterminers = new String[]{"such", "several", "most", "more", "many", "less", "few", "enough", "both", "all", "those", "this", "these", "the", "that", "some", "no", "neither", "every", "either", "each", "any", "another", "an", "a"};
    public static final String[] possessivePronouns = new String[]{"my", "your", "his", "her", "its", "our", "their"};
    static final String[] predCompVerbs = new String[]{"be", "become"};
    static final String[] complementHeadCats = new String[]{"adj", "ven", "pp"};

    public static void annotate(Document doc, Span span) {
        Annotation parse;
        Annotation sentence;
        Vector<Annotation> sentences = doc.annotationsAt(span.start(), "sentence");
        if (sentences != null && sentences.size() > 0 && (sentence = sentences.get(0)).get("parse") instanceof Annotation && (parse = (Annotation)sentence.get("parse")) != null) {
            AddSyntacticRelations.annotateParseTree(doc, parse);
            return;
        }
        Vector<Annotation> constits = doc.annotationsOfType("constit");
        if (constits == null) {
            return;
        }
        for (int i = 0; i < constits.size(); ++i) {
            Annotation constit = constits.get(i);
            if (!constit.span().within(span)) continue;
            AddSyntacticRelations.annotateConstit(doc, constit);
        }
    }

    private static void annotateParseTree(Document doc, Annotation node) {
        if (node == null) {
            return;
        }
        AddSyntacticRelations.annotateConstit(doc, node);
        Annotation[] children = ParseTreeNode.children(node);
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                AddSyntacticRelations.annotateParseTree(doc, children[i]);
            }
        }
    }

    private static void annotateConstit(Document doc, Annotation constit) {
        AddSyntacticRelations.restructurePoss(doc, constit);
        AddSyntacticRelations.restructureConj(doc, constit);
        AddSyntacticRelations.processS(doc, constit, null);
        AddSyntacticRelations.processNP(doc, constit);
        AddSyntacticRelations.addOfRelation(doc, constit);
        AddSyntacticRelations.addPObjRelation(doc, constit);
        AddSyntacticRelations.addDetRelation(doc, constit);
        AddSyntacticRelations.addPreNameRelation(doc, constit);
        AddSyntacticRelations.addAppositeRelation(doc, constit);
        AddSyntacticRelations.addPredCompRelation(doc, constit);
        AddSyntacticRelations.addConjRelation(doc, constit);
    }

    private static void restructurePoss(Document doc, Annotation constit) {
        if (constit.get("cat") != "np") {
            return;
        }
        Annotation[] children = ParseTreeNode.children(constit);
        if (children.length <= 1) {
            return;
        }
        Annotation lastChild = children[children.length - 1];
        if (lastChild != null && lastChild.get("cat") == "pos") {
            Annotation[] childrenExceptPos = new Annotation[children.length - 1];
            for (int i = 0; i < childrenExceptPos.length; ++i) {
                childrenExceptPos[i] = children[i];
            }
            Annotation headInnerNP = childrenExceptPos[childrenExceptPos.length - 1];
            int endInnerNP = childrenExceptPos[childrenExceptPos.length - 1].end();
            Annotation innerNP = new Annotation("constit", new Span(constit.start(), endInnerNP), new FeatureSet("cat", "np", "children", childrenExceptPos, "headC", headInnerNP));
            doc.addAnnotation(innerNP);
            children = new Annotation[]{innerNP, lastChild};
            constit.put("cat", "np$");
            constit.put("children", children);
        }
    }

    private static void restructureConj(Document doc, Annotation constit) {
        if (constit.get("cat") != "np") {
            return;
        }
        Annotation headC = (Annotation)constit.get("headC");
        if (headC != null && headC.get("cat") == "np") {
            return;
        }
        Annotation[] children = ParseTreeNode.children(constit);
        if (children.length < 3) {
            return;
        }
        int iconj = 0;
        for (int ichild = 1; ichild < children.length - 1; ++ichild) {
            Annotation child = children[ichild];
            if (child == null || child.get("cat") != "cconj") continue;
            iconj = ichild;
            break;
        }
        if (iconj == 0) {
            return;
        }
        Annotation[] leftChildren = new Annotation[iconj];
        for (int i = 0; i < iconj; ++i) {
            leftChildren[i] = children[i];
        }
        Annotation[] rightChildren = new Annotation[children.length - iconj - 1];
        for (int i = iconj + 1; i < children.length; ++i) {
            rightChildren[i - iconj - 1] = children[i];
        }
        Annotation conjunct = children[iconj];
        Annotation leftNP = new Annotation("constit", new Span(constit.start(), conjunct.start()), new FeatureSet("cat", "np", "children", leftChildren, "headC", leftChildren[leftChildren.length - 1]));
        doc.addAnnotation(leftNP);
        Annotation rightNP = new Annotation("constit", new Span(conjunct.end(), constit.end()), new FeatureSet("cat", "np", "children", rightChildren, "headC", rightChildren[rightChildren.length - 1]));
        doc.addAnnotation(rightNP);
        children = new Annotation[]{leftNP, conjunct, rightNP};
        constit.put("children", children);
        constit.put("headC", rightNP);
    }

    private static void processS(Document doc, Annotation node, Annotation head) {
        Annotation pp;
        Annotation subject;
        Object part;
        String cat = (String)node.get("cat");
        if (cat != "s") {
            return;
        }
        FeatureSet pa = (FeatureSet)node.get("pa");
        if (pa != null) {
            return;
        }
        Annotation vp = AddSyntacticRelations.assignVerbPa(doc, node, node);
        pa = (FeatureSet)node.get("pa");
        if (vp == null || pa == null) {
            return;
        }
        Annotation partC = AddSyntacticRelations.childWithCat(vp, "prt");
        if (partC != null && (partC = Resolve.getHeadC(partC)).get("cat") == "dp" && (part = partC.get("pa")) instanceof String) {
            pa.put("part", part);
        }
        if ((subject = AddSyntacticRelations.nonTimeNP(node)) == null && head != null) {
            subject = head;
        }
        Annotation object = AddSyntacticRelations.nonTimeNP(vp);
        if (pa.get("voice") != "passive") {
            if (subject != null) {
                node.put("subject", subject);
            }
            if (object != null) {
                node.put("object", object);
            }
        } else if (subject != null) {
            node.put("object", subject);
        }
        if ((pp = AddSyntacticRelations.childWithCat(vp, "pp")) != null) {
            Annotation ppObj;
            node.put("pp", pp);
            String prep = AddSyntacticRelations.getPreposition(doc, pp);
            if (prep != null && Resolve.in(prep, prepositions) && (ppObj = AddSyntacticRelations.getPPObj(doc, pp)) != null) {
                node.put(prep, ppObj);
            }
        }
    }

    private static void processNP(Document doc, Annotation node) {
        if (node.get("cat") != "np") {
            return;
        }
        Annotation np2 = AddSyntacticRelations.childWithCat(node, "np");
        Annotation vp = AddSyntacticRelations.childWithCat(node, "vp");
        Annotation sbar = AddSyntacticRelations.childWithCat(node, "sbar");
        if (np2 != null && vp != null) {
            Annotation vp2 = AddSyntacticRelations.processBeComplement(vp, vp, doc, null);
            FeatureSet pa = (FeatureSet)vp.get("pa");
            if (vp2 == null || pa == null) {
                return;
            }
            Annotation object = AddSyntacticRelations.nonTimeNP(vp2);
            if (pa.get("voice") != "passive") {
                vp.put("subject", np2);
                if (object != null) {
                    vp.put("object", object);
                }
            } else {
                vp.put("object", np2);
            }
            return;
        }
        if (np2 != null && sbar != null) {
            Annotation s;
            Annotation whnp = AddSyntacticRelations.childWithCat(sbar, "whnp");
            if (whnp != null) {
                whnp.put("host", node);
            }
            if ((s = AddSyntacticRelations.childWithCat(sbar, "s")) != null) {
                AddSyntacticRelations.processS(doc, s, np2);
                return;
            }
        }
    }

    private static Annotation assignVerbPa(Document doc, Annotation node, Annotation s) {
        Annotation v;
        Annotation vp2;
        Annotation ven;
        Annotation z;
        Annotation vp22;
        Annotation vp1 = AddSyntacticRelations.childWithCat(node, "vp");
        if (vp1 == null) {
            return null;
        }
        Annotation to = AddSyntacticRelations.childWithCat(vp1, "p");
        if (to != null) {
            return AddSyntacticRelations.assignVerbPa(doc, vp1, s);
        }
        Annotation mainV = AddSyntacticRelations.childWithCat(vp1, "tv");
        if (mainV == null) {
            mainV = AddSyntacticRelations.childWithCat(vp1, "ving");
        }
        if (mainV == null) {
            mainV = AddSyntacticRelations.childWithCat(vp1, "v");
        }
        if (mainV != null && SynFun.getImmediateHead(mainV) == "be" && (vp22 = AddSyntacticRelations.childWithCat(vp1, "vp")) != null && (z = AddSyntacticRelations.processBeComplement(node, vp22, doc, vp1)) != null) {
            return z;
        }
        if (mainV != null && SynFun.getImmediateHead(mainV) == "have" && (vp22 = AddSyntacticRelations.childWithCat(vp1, "vp")) != null && (ven = AddSyntacticRelations.childWithCat(vp22, "ven")) != null) {
            Annotation vp3;
            if (SynFun.getImmediateHead(ven) == "be" && (vp3 = AddSyntacticRelations.childWithCat(vp22, "vp")) != null) {
                Annotation ving = AddSyntacticRelations.childWithCat(vp3, "ving");
                if (ving != null) {
                    FeatureSet pa = AddSyntacticRelations.paCopy(ving);
                    s.put("pa", pa);
                    s.put("mainV", ving);
                    AddSyntacticRelations.recordVg(doc, "vg", vp1.start(), ving.end());
                    return vp3;
                }
                Annotation ven2 = AddSyntacticRelations.childWithCat(vp3, "ven");
                if (ven2 != null) {
                    FeatureSet pa = AddSyntacticRelations.paCopy(ven2);
                    s.put("pa", pa);
                    s.put("mainV", ven2);
                    String idStr = (String)s.get("id");
                    if (pa != null) {
                        pa.put("voice", "passive");
                    }
                    AddSyntacticRelations.recordVg(doc, "vg-pass", vp1.start(), ven2.end());
                    return vp3;
                }
            }
            FeatureSet pa = AddSyntacticRelations.paCopy(ven);
            s.put("pa", pa);
            s.put("mainV", ven);
            AddSyntacticRelations.recordVg(doc, "vg", vp1.start(), ven.end());
            return vp22;
        }
        Annotation aux = AddSyntacticRelations.childWithCat(vp1, "w");
        if (aux != null && (vp2 = AddSyntacticRelations.childWithCat(vp1, "vp")) != null && (v = AddSyntacticRelations.childWithCat(vp2, "v")) != null) {
            FeatureSet pa = AddSyntacticRelations.paCopy(v);
            s.put("pa", pa);
            s.put("mainV", v);
            AddSyntacticRelations.recordVg(doc, "vg", vp1.start(), v.end());
            return vp2;
        }
        if (mainV != null) {
            FeatureSet pa = AddSyntacticRelations.paCopy(mainV);
            s.put("pa", pa);
            s.put("mainV", mainV);
            AddSyntacticRelations.recordVg(doc, "vg", vp1.start(), mainV.end());
            return vp1;
        }
        return null;
    }

    private static void recordVg(Document doc, String cat, int start, int end) {
        doc.annotate("constit", new Span(start, end), new FeatureSet("cat", cat));
    }

    private static Annotation processBeComplement(Annotation s, Annotation vp2, Document doc, Annotation vp1) {
        Annotation ving = AddSyntacticRelations.childWithCat(vp2, "ving");
        if (ving != null) {
            FeatureSet pa = AddSyntacticRelations.paCopy(ving);
            String id = (String)s.get("id");
            s.put("pa", pa);
            s.put("mainV", ving);
            if (vp1 == null) {
                vp1 = ving;
            }
            AddSyntacticRelations.recordVg(doc, "vg", vp1.start(), ving.end());
            return vp2;
        }
        Annotation ven = AddSyntacticRelations.childWithCat(vp2, "ven");
        if (ven != null) {
            FeatureSet pa = AddSyntacticRelations.paCopy(ven);
            String id = (String)s.get("id");
            if (pa != null) {
                pa.put("voice", "passive");
            }
            s.put("pa", pa);
            s.put("mainV", ven);
            if (vp1 == null) {
                vp1 = ven;
            }
            AddSyntacticRelations.recordVg(doc, "vg-pass", vp1.start(), ven.end());
            return vp2;
        }
        return null;
    }

    private static Annotation childWithCat(Annotation node, String cat) {
        Annotation[] children = ParseTreeNode.children(node);
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            Annotation child = children[i];
            if (child == null || child.get("cat") != cat) continue;
            return child;
        }
        return null;
    }

    private static Annotation nonTimeNP(Annotation node) {
        Annotation[] children = ParseTreeNode.children(node);
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            Annotation headC;
            Annotation child = children[i];
            if (child == null || child.get("cat") != "np" || (headC = Resolve.getHeadC(child)) != null && (headC.get("ntime") != null || headC.get("cat") == "timex")) continue;
            return child;
        }
        return null;
    }

    private static FeatureSet paCopy(Annotation node) {
        Object pa = node.get("pa");
        if (pa == null) {
            return null;
        }
        if (!(pa instanceof FeatureSet)) {
            return null;
        }
        FeatureSet fs = (FeatureSet)pa;
        return new FeatureSet(fs);
    }

    private static void addOfRelation(Document doc, Annotation constit) {
        String cat = (String)constit.get("cat");
        Annotation[] children = ParseTreeNode.children(constit);
        if (cat == "np" && children != null && children.length >= 2) {
            Annotation[] ppChildren;
            Annotation npHead = children[0];
            Annotation pp = children[1];
            if (npHead != null && npHead.get("cat") == "np" && pp != null && pp.get("cat") == "pp" && (ppChildren = (Annotation[])pp.get("children")).length == 2) {
                String prep;
                Annotation in = ppChildren[0];
                Annotation npObj = ppChildren[1];
                if (in != null && in.get("cat") == "p" && npObj != null && npObj.get("cat") == "np" && Resolve.in(prep = doc.text(in).trim().toLowerCase(), prepositions)) {
                    constit.put(prep, npObj);
                }
            }
        }
    }

    private static void addPObjRelation(Document doc, Annotation pp) {
        String cat = (String)pp.get("cat");
        Annotation[] ppChildren = ParseTreeNode.children(pp);
        if (cat == "pp" && ppChildren != null && ppChildren.length >= 2) {
            Annotation in = null;
            Annotation npObj = null;
            int w = AddSyntacticRelations.findPrepositionIndex(pp);
            if (w >= 0 && w < ppChildren.length - 1) {
                in = ppChildren[w];
                npObj = ppChildren[w + 1];
            }
            if (in != null && npObj.get("cat") == "np") {
                String prep = doc.text(in).trim();
                pp.put("p-obj", npObj);
                npObj.put("p-obj-1", pp);
            }
        }
    }

    public static int findPrepositionIndex(Annotation pp) {
        Annotation[] ppChildren = ParseTreeNode.children(pp);
        for (int w = 0; w < ppChildren.length; ++w) {
            Annotation temp = ppChildren[w];
            if (!temp.get("cat").equals("p") && !temp.get("cat").equals("dp")) continue;
            return w;
        }
        return -1;
    }

    private static String getPreposition(Document doc, Annotation pp) {
        int w = AddSyntacticRelations.findPrepositionIndex(pp);
        if (w >= 0) {
            Annotation in = ParseTreeNode.children(pp)[w];
            return doc.text(in).trim();
        }
        return null;
    }

    private static Annotation getPPObj(Document doc, Annotation pp) {
        Annotation npObj;
        Annotation[] ppChildren = ParseTreeNode.children(pp);
        int w = AddSyntacticRelations.findPrepositionIndex(pp);
        if (w >= 0 && w < ppChildren.length - 1 && (npObj = ppChildren[w + 1]).get("cat") == "np") {
            return npObj;
        }
        return null;
    }

    private static void addDetRelation(Document doc, Annotation constit) {
        String cat = (String)constit.get("cat");
        if (cat != "np") {
            return;
        }
        Annotation ngHead = Resolve.getNgHead(constit);
        Annotation[] children = ParseTreeNode.children(ngHead);
        if (children != null && children.length >= 2) {
            Annotation firstChild = children[0];
            AddSyntacticRelations.restructurePoss(doc, firstChild);
            String det = doc.text(firstChild).trim().toLowerCase().intern();
            if (Resolve.in(det, comlexDeterminers)) {
                constit.put("det", det);
            } else if (Resolve.in(det, possessivePronouns)) {
                constit.put("det", "poss");
                constit.put("poss", firstChild);
            } else if (firstChild.get("cat") == "np$") {
                constit.put("det", "poss");
                constit.put("poss", ParseTreeNode.children(firstChild)[0]);
            } else if (firstChild.get("cat") == "q" || firstChild.get("cat") == "qp") {
                constit.put("det", "q");
            }
        }
    }

    private static void addAppositeRelation(Document doc, Annotation constit) {
        String cat = (String)constit.get("cat");
        Annotation[] children = ParseTreeNode.children(constit);
        if (cat == "np" && children != null && (children.length == 3 || children.length == 4) && children[0] != null && children[1] != null && children[2] != null && children[0].get("cat") == "np" && children[1].get("cat") == "," && children[2].get("cat") == "np" && (children.length == 3 || children[3] != null && children[3].get("cat") == ",")) {
            boolean name2;
            Annotation head1 = Resolve.getHeadC(children[0]);
            Annotation head2 = Resolve.getHeadC(children[2]);
            boolean name1 = head1.get("cat") == "name";
            boolean bl = name2 = head2.get("cat") == "name";
            if (name1 && !name2 || name2 && !name1) {
                constit.put("apposite", children[2]);
            }
        }
    }

    private static void addPreNameRelation(Document doc, Annotation constit) {
        String cat = (String)constit.get("cat");
        if (cat != "np") {
            return;
        }
        Annotation headC = Resolve.getHeadC(constit);
        Annotation ngHead = Resolve.getNgHead(constit);
        Annotation[] children = ParseTreeNode.children(ngHead);
        if (children != null && children.length >= 2) {
            Annotation lastLeftMod;
            if (headC.get("cat") == "name" && ((lastLeftMod = children[children.length - 2]).get("cat") == "title" || lastLeftMod.get("cat") == "n")) {
                constit.put("preName", lastLeftMod);
                lastLeftMod.put("preName-1", constit);
            }
            for (int i = 0; i < children.length - 1; ++i) {
                Annotation leftMod = children[i];
                if (leftMod.get("cat") != "name") continue;
                constit.put("nameMod", leftMod);
                leftMod.put("nameMod-1", constit);
            }
        }
    }

    private static void addPredCompRelation(Document doc, Annotation constit) {
        String cat = (String)constit.get("cat");
        Annotation[] children = ParseTreeNode.children(constit);
        if (cat == "s" && children != null && children.length >= 2 && children[0] != null && children[0].get("cat") == "np" && children[1] != null && children[1].get("cat") == "vp") {
            Annotation subject = children[0];
            String subjectHead = SynFun.getHead(doc, subject);
            if ("there".equalsIgnoreCase(subjectHead)) {
                return;
            }
            if ("it".equalsIgnoreCase(subjectHead)) {
                return;
            }
            Annotation vp = children[1];
            Annotation[] vpChildren = (Annotation[])vp.get("children");
            if (vpChildren != null && vpChildren.length >= 2 && vpChildren[0].get("cat") == "tv" && Resolve.in(SynFun.getHead(doc, vpChildren[0]), predCompVerbs) && (vpChildren[1].get("cat").equals("np") || Resolve.in(Resolve.getHeadC(vpChildren[1]).get("cat"), complementHeadCats))) {
                subject.put("predComp", vpChildren[1]);
            }
        }
    }

    private static void addConjRelation(Document doc, Annotation constit) {
        if (constit.get("cat") != "np") {
            return;
        }
        Annotation[] children = ParseTreeNode.children(constit);
        if (children.length == 3 && children[0].get("cat") == "np" && children[1].get("cat") == "cconj" && children[2].get("cat") == "np") {
            children[0].put("conj", children[2]);
        }
    }
}

