/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.format.InvalidFormatException;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.util.IOUtils;
import edu.nyu.jet.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadRule {
    private static final String DEFAULT_RULE_PATH = "edu/nyu/jet/parser/head_rule.txt";
    private static final String DEFAULT_RULE_ENCODING = "US-ASCII";
    private static final HeadRule defaultInstance = HeadRule.createDefaultRule();
    private Map<String, HeadRuleEntry> rules = new HashMap<String, HeadRuleEntry>();
    private static final Pattern puncOrParenPattern = Pattern.compile("[\\p{P}\\p{Ps}\\p{Pc}]+");

    private HeadRule() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HeadRule createDefaultRule() {
        HeadRule instance = new HeadRule();
        InputStream rawIn = HeadRule.class.getClassLoader().getResourceAsStream(DEFAULT_RULE_PATH);
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(rawIn, DEFAULT_RULE_ENCODING);
            instance.load(in);
        }
        catch (UnsupportedOperationException ex) {
            try {
                throw new RuntimeException(ex);
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
                catch (InvalidFormatException ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(rawIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        IOUtils.closeQuietly(rawIn);
        return instance;
    }

    public static HeadRule getDefaultRule() {
        return defaultInstance;
    }

    public static HeadRule getRule(Reader in) throws IOException, InvalidFormatException {
        HeadRule rule = new HeadRule();
        rule.load(in);
        return rule;
    }

    public static HeadRule getRule(File file) throws IOException, InvalidFormatException {
        HeadRule rule = new HeadRule();
        rule.load(file);
        return rule;
    }

    public int getHead(ParseTreeNode node) {
        int step;
        int end;
        int start;
        String category = (String)node.category;
        HeadRuleEntry entry = this.rules.get(category);
        ParseTreeNode[] children = node.children;
        if (category.equals("np")) {
            String ccat;
            int i;
            for (i = children.length - 1; i >= 0; --i) {
                ccat = (String)children[i].category;
                if (!ccat.startsWith("nn") && !ccat.equals("nx") && !ccat.equals("pos") && !ccat.equals("jjr")) continue;
                return i + 1;
            }
            for (i = 0; i < children.length; ++i) {
                ccat = (String)children[i].category;
                if (!ccat.equals("np")) continue;
                return i + 1;
            }
        }
        if (entry == null) {
            if (children.length == 1) {
                return 1;
            }
            return 0;
        }
        switch (entry.getDirection()) {
            case LEFT_TO_RIGHT: {
                start = 0;
                end = children.length;
                step = 1;
                break;
            }
            case RIGHT_TO_LEFT: {
                start = children.length - 1;
                end = -1;
                step = -1;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        for (String priority : entry.getPriorityList()) {
            for (int i = start; i != end; i += step) {
                ParseTreeNode child = children[i];
                if (!priority.equals(child.category)) continue;
                return i + 1;
            }
        }
        for (int i = start; i != end; i += step) {
            if (!this.isTerminal(children[i])) {
                return i + 1;
            }
            if (this.isPunctuationOrParenthesis(children[i])) continue;
            return i + 1;
        }
        return start;
    }

    public void apply(ParseTreeNode tree) {
        if (tree.children == null || tree.children.length == 0) {
            return;
        }
        tree.head = this.getHead(tree);
        for (ParseTreeNode child : tree.children) {
            this.apply(child);
        }
    }

    public void addEntry(String category, ScanDirection direction, List<String> priorityList) {
        HeadRuleEntry entry = new HeadRuleEntry(category, direction, priorityList);
        this.rules.put(category, entry);
    }

    private void load(Reader in) throws IOException, InvalidFormatException {
        String line;
        LineNumberReader input = null;
        input = in instanceof BufferedReader ? new LineNumberReader(in) : new LineNumberReader(new BufferedReader(in));
        Pattern ruleRegex = Pattern.compile("^(\\w+) \\s+ (left-to-right|right-to-left) \\s+ (.*)$", 4);
        Pattern separator = Pattern.compile("\\s+");
        while ((line = input.readLine()) != null) {
            if (line.startsWith("#")) continue;
            Matcher matcher = ruleRegex.matcher(line);
            if (!matcher.matches()) {
                throw new InvalidFormatException("Invalid format at line " + input.getLineNumber());
            }
            String category = matcher.group(1).toLowerCase();
            ScanDirection direction = this.getScanDirection(matcher.group(2));
            List<String> priorityList = Arrays.asList(separator.split(matcher.group(3).toLowerCase()));
            this.addEntry(category, direction, priorityList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) throws IOException, InvalidFormatException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.load(reader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
    }

    private ScanDirection getScanDirection(String key) {
        if (key.equals("left-to-right")) {
            return ScanDirection.LEFT_TO_RIGHT;
        }
        if (key.equals("right-to-left")) {
            return ScanDirection.RIGHT_TO_LEFT;
        }
        return null;
    }

    private boolean isTerminal(ParseTreeNode node) {
        return node.children == null;
    }

    private boolean isPunctuationOrParenthesis(ParseTreeNode node) {
        return puncOrParenPattern.matcher(node.word).matches();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScanDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeadRuleEntry {
        private String category;
        private ScanDirection direction;
        private List<String> priorityList;

        public HeadRuleEntry(String category, ScanDirection direction, List<String> priorityList) {
            this.category = category;
            this.direction = direction;
            this.priorityList = priorityList;
        }

        public HeadRuleEntry() {
            this(null, null, new ArrayList<String>());
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public ScanDirection getDirection() {
            return this.direction;
        }

        public void setDirection(ScanDirection direction) {
            this.direction = direction;
        }

        public List<String> getPriorityList() {
            return this.priorityList;
        }

        public void setPriorityList(List<String> priorityList) {
            this.priorityList = priorityList;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.category);
            switch (this.direction) {
                case LEFT_TO_RIGHT: {
                    builder.append(" LR ");
                    break;
                }
                case RIGHT_TO_LEFT: {
                    builder.append(" RL ");
                }
            }
            builder.append(StringUtils.join(" ", this.priorityList));
            return builder.toString();
        }
    }
}

