/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.Console;
import edu.nyu.jet.lisp.Literal;
import edu.nyu.jet.parser.ActiveEdge;
import edu.nyu.jet.parser.Edge;
import edu.nyu.jet.parser.Grammar;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.parser.ParseView;
import edu.nyu.jet.parser.Production;
import edu.nyu.jet.parser.Reduce;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;

public class Parsers {
    static final String NULL = "null";
    static final String SENTENCE = "sentence";
    public static final int RECOGNIZE = 1;
    public static final int TDPARSE = 2;
    public static final int BUPARSE = 3;
    public static final int CHARTPARSE = 4;
    public static int parserType = 1;
    static Vector parses = new Vector();
    public static boolean parserTrace = true;
    static Stack agenda;
    static Vector chart;
    static Hashtable sought;

    public static Vector parse(Document doc, int posn, int end, Grammar gram) {
        switch (parserType) {
            case 1: {
                parses = new Vector();
                if (Parsers.recognize(doc, posn, end, gram)) {
                    parses.addElement(null);
                }
                return parses;
            }
            case 2: {
                return Parsers.TDParse(doc, posn, end, gram);
            }
            case 3: {
                return Parsers.BUParse(doc, posn, end, gram);
            }
            case 4: {
                return Parsers.chartParse(doc, posn, end, gram);
            }
        }
        return new Vector();
    }

    public static boolean recognize(Document doc, int posn, int end, Grammar gram) {
        Stack<String> goals = new Stack<String>();
        goals.push(SENTENCE);
        return Parsers.recognize(doc, posn, end, gram, goals);
    }

    private static boolean recognize(Document doc, int posn, int end, Grammar gram, Stack goals) {
        Vector productions;
        if (goals.empty()) {
            if (posn == end) {
                Console.println("Sentence recognized.");
                return true;
            }
            return false;
        }
        Object goal = goals.pop();
        Parsers.printParseTrace("Seeking " + goal, posn, 0);
        if (goal == NULL) {
            return Parsers.recognize(doc, posn, end, gram, goals);
        }
        if (goal instanceof Literal) {
            Annotation token = doc.tokenAt(posn);
            if (token != null && ((Literal)goal).getString().equals(doc.text(token).trim())) {
                posn = token.span().end();
                return Parsers.recognize(doc, posn, end, gram, goals);
            }
            return false;
        }
        Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.elementAt(i);
                if (constit.get("cat") != goal) continue;
                posn = constit.span().end();
                return Parsers.recognize(doc, posn, end, gram, goals);
            }
        }
        if ((productions = gram.getProductions((String)goal)) != null) {
            for (int i = 0; i < productions.size(); ++i) {
                Production production = (Production)productions.elementAt(i);
                Vector rhs = production.rhs();
                Stack newgoals = (Stack)goals.clone();
                for (int j = rhs.size() - 1; j >= 0; --j) {
                    newgoals.push(rhs.elementAt(j));
                }
                if (!Parsers.recognize(doc, posn, end, gram, newgoals)) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector TDParse(Document doc, int posn, int end, Grammar gram) {
        Stack<String> goals = new Stack<String>();
        Stack trees = new Stack();
        parses = new Stack();
        goals.push(SENTENCE);
        Parsers.TDParse(doc, posn, end, gram, goals, trees);
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static void TDParse(Document doc, int posn, int end, Grammar gram, Stack goals, Stack trees) {
        Vector productions;
        if (goals.empty()) {
            if (posn == end) {
                if (parserTrace) {
                    Console.println("Sentence parsed.");
                }
                parses.addElement(trees.pop());
            }
            return;
        }
        Object goal = goals.pop();
        if (goal instanceof Reduce) {
            String category = ((Reduce)goal).category;
            int nChildren = ((Reduce)goal).numberOfChildren;
            ParseTreeNode[] children = new ParseTreeNode[nChildren];
            for (int i = nChildren - 1; i >= 0; --i) {
                children[i] = (ParseTreeNode)trees.pop();
            }
            int start = children[0].start;
            trees.push(new ParseTreeNode((Object)category, children, start, posn, null, null));
            Parsers.printParseTrace("Found   " + category + " = " + doc.text(new Span(start, posn)), start, posn);
            Parsers.TDParse(doc, posn, end, gram, goals, trees);
            return;
        }
        Parsers.printParseTrace("Seeking " + goal, posn, 0);
        if (goal == NULL) {
            trees.push(new ParseTreeNode((Object)NULL, null, posn, posn, null, null));
            Parsers.TDParse(doc, posn, end, gram, goals, trees);
            return;
        }
        if (goal instanceof Literal) {
            Annotation token = doc.tokenAt(posn);
            if (token != null && ((Literal)goal).getString().equals(doc.text(token).trim())) {
                int newposn = token.span().end();
                trees.push(new ParseTreeNode(goal, null, posn, newposn, token, (String)goal));
                Parsers.printParseTrace("Found   " + goal, posn, newposn);
                Parsers.TDParse(doc, newposn, end, gram, goals, trees);
            }
            return;
        }
        String cat = (String)goal;
        Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.elementAt(i);
                if (constit.get("cat") != cat) continue;
                int newposn = constit.span().end();
                trees.push(new ParseTreeNode((Object)cat, null, posn, newposn, constit, doc.text(constit)));
                Parsers.printParseTrace("Found   " + goal + " = " + doc.text(new Span(posn, newposn)), posn, newposn);
                Parsers.TDParse(doc, newposn, end, gram, goals, trees);
                return;
            }
        }
        if ((productions = gram.getProductions(cat)) != null) {
            for (int i = 0; i < productions.size(); ++i) {
                Production production = (Production)productions.elementAt(i);
                Vector rhs = production.rhs();
                Stack newgoals = (Stack)goals.clone();
                Stack newtrees = (Stack)trees.clone();
                newgoals.push(new Reduce(cat, rhs.size()));
                for (int j = rhs.size() - 1; j >= 0; --j) {
                    newgoals.push(rhs.elementAt(j));
                }
                Parsers.TDParse(doc, posn, end, gram, newgoals, newtrees);
            }
        }
    }

    public static Vector BUParse(Document doc, int posn, int end, Grammar gram) {
        int start = posn;
        agenda = new Stack();
        chart = new Vector();
        parses = new Vector();
        while (posn >= 0 && posn < end) {
            posn = Parsers.addLexicalNodes(doc, posn);
            while (!agenda.empty()) {
                ParseTreeNode node = (ParseTreeNode)agenda.pop();
                Vector prods = gram.getProductionsEndingIn(node.category);
                if (prods != null) {
                    for (int i = 0; i < prods.size(); ++i) {
                        Production prod = (Production)prods.elementAt(i);
                        int prodLength = prod.rhs.size();
                        ParseTreeNode[] constituents = new ParseTreeNode[prodLength];
                        constituents[prodLength - 1] = node;
                        Parsers.extend(doc, prod, node.start, node.end, constituents, prodLength - 2);
                    }
                }
                if (node.category != SENTENCE || node.start != start || node.end != end) continue;
                parses.addElement(node);
            }
        }
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static int addLexicalNodes(Document doc, int posn) {
        Annotation token = doc.tokenAt(posn);
        if (token == null) {
            return -1;
        }
        Parsers.addNode(doc, doc.text(token).trim(), null, posn, token.span().end(), token, doc.text(token));
        Vector<Annotation> constits = doc.annotationsAt(posn, "constit");
        if (constits != null) {
            for (int i = 0; i < constits.size(); ++i) {
                Annotation constit = constits.elementAt(i);
                Parsers.addNode(doc, constit.get("cat"), null, posn, constit.span().end(), constit, doc.text(constit));
            }
        }
        return token.span().end();
    }

    private static void addNode(Document doc, Object category, ParseTreeNode[] children, int start, int end, Annotation ann, String word) {
        if (category instanceof String) {
            Parsers.printParseTrace("Adding " + category, start, end);
        } else {
            Parsers.printParseTrace("Adding " + category + " = " + doc.text(new Span(start, end)), start, end);
        }
        ParseTreeNode node = new ParseTreeNode(category, children, start, end, ann, word);
        chart.addElement(node);
        if (parserType == 3) {
            agenda.push(node);
        }
    }

    private static void extend(Document doc, Production prod, int start, int end, ParseTreeNode[] constituents, int n) {
        if (n >= 0) {
            Object element = prod.rhs.elementAt(n);
            for (int i = 0; i < chart.size(); ++i) {
                ParseTreeNode node = (ParseTreeNode)chart.elementAt(i);
                if (node.category != element || node.end != start) continue;
                constituents[n] = node;
                Parsers.extend(doc, prod, node.start, end, constituents, n - 1);
            }
        } else {
            ParseTreeNode[] c = (ParseTreeNode[])constituents.clone();
            Parsers.addNode(doc, prod.lhs, c, start, end, null, null);
        }
    }

    public static Vector chartParse(Document doc, int posn, int end, Grammar gram) {
        int start = posn;
        agenda = new Stack();
        chart = new Vector();
        parses = new Vector();
        sought = new Hashtable();
        while (posn >= 0 && posn < end) {
            posn = Parsers.addLexicalNodes(doc, posn);
        }
        Parsers.seek(SENTENCE, start, gram);
        while (!agenda.empty()) {
            Edge edge = (Edge)agenda.pop();
            chart.addElement(edge);
            if (edge.end > edge.start) {
                Parsers.printParseTrace("Adding " + edge + " = " + doc.text(new Span(edge.start, edge.end)), edge.start, edge.end);
            } else {
                Parsers.printParseTrace("Adding " + edge, edge.start, edge.end);
            }
            if (edge instanceof ParseTreeNode) {
                ParseTreeNode node = (ParseTreeNode)edge;
                if (node.category == SENTENCE && node.start == start && node.end == end) {
                    parses.addElement(node);
                }
            }
            if (edge instanceof ActiveEdge) {
                Parsers.extendActiveEdge((ActiveEdge)edge, gram);
                continue;
            }
            Parsers.extendInactiveEdge((ParseTreeNode)edge, gram);
        }
        Console.println(parses.size() + " parse(s) obtained");
        return parses;
    }

    private static void seek(String cat, int posn, Grammar gram) {
        Parsers.printParseTrace("Seeking " + cat, posn, 0);
        if (!sought.containsKey(cat)) {
            sought.put(cat, new Hashtable());
        }
        Hashtable soughtCat = (Hashtable)sought.get(cat);
        soughtCat.put(new Integer(posn), Boolean.TRUE);
        Vector productions = gram.getProductions(cat);
        if (productions != null) {
            for (int i = 0; i < productions.size(); ++i) {
                Production production = (Production)productions.elementAt(i);
                Vector rhs = production.rhs();
                ActiveEdge e = new ActiveEdge(cat, rhs, new ParseTreeNode[0], posn, posn);
                agenda.push(e);
            }
        }
    }

    private static boolean getSought(String cat, int posn) {
        Hashtable soughtCat = (Hashtable)sought.get(cat);
        if (soughtCat == null) {
            return false;
        }
        return soughtCat.containsKey(new Integer(posn));
    }

    private static void extendActiveEdge(ActiveEdge edge, Grammar gram) {
        String cat;
        String needed = edge.needs();
        int posn = edge.end;
        if (needed instanceof String && gram.defines(cat = needed) && !Parsers.getSought(cat, posn)) {
            Parsers.seek(cat, posn, gram);
            return;
        }
        for (int i = 0; i < chart.size(); ++i) {
            if (!(chart.elementAt(i) instanceof ParseTreeNode)) continue;
            ParseTreeNode node = (ParseTreeNode)chart.elementAt(i);
            if (node.start != posn || node.category != needed) continue;
            Parsers.extendEdge(edge, node, gram);
        }
    }

    private static void extendInactiveEdge(ParseTreeNode node, Grammar gram) {
        int posn = node.start;
        for (int i = 0; i < chart.size(); ++i) {
            if (!(chart.elementAt(i) instanceof ActiveEdge)) continue;
            ActiveEdge edge = (ActiveEdge)chart.elementAt(i);
            if (edge.end != posn || edge.needs() != node.category) continue;
            Parsers.extendEdge(edge, node, gram);
        }
    }

    private static void extendEdge(ActiveEdge edge, ParseTreeNode node, Grammar gram) {
        if (parserTrace) {
            Console.println("Extending " + edge + " with " + node);
        }
        ParseTreeNode[] children = edge.children;
        ParseTreeNode[] newChildren = new ParseTreeNode[children.length + 1];
        for (int i = 0; i < children.length; ++i) {
            newChildren[i] = children[i];
        }
        newChildren[children.length] = node;
        if (newChildren.length == edge.rhs.size()) {
            ParseTreeNode newNode = new ParseTreeNode(edge.category, newChildren, edge.start, node.end, null, null);
            agenda.push(newNode);
        } else {
            ActiveEdge newEdge = new ActiveEdge(edge.category, edge.rhs, newChildren, edge.start, node.end);
            agenda.push(newEdge);
        }
    }

    private static void printParseTrace(String message, int start, int end) {
        if (parserTrace) {
            int i;
            StringBuffer sb;
            if (message.length() < 40) {
                sb = new StringBuffer(message);
                for (i = message.length(); i < 40; ++i) {
                    sb.append(' ');
                }
            } else {
                Console.println(message);
                sb = new StringBuffer("                                        ");
            }
            for (i = 0; i < start; ++i) {
                sb.append(' ');
            }
            if (start >= end) {
                sb.append('+');
            } else {
                for (i = start; i < end; ++i) {
                    sb.append('=');
                }
            }
            Console.println(sb.toString());
        }
    }

    public static JMenu parserMenu() {
        JMenu menu = new JMenu("Parser");
        menu.setMnemonic(65);
        JRadioButtonMenuItem recognizerItem = new JRadioButtonMenuItem("Use Recognizer");
        recognizerItem.setMnemonic(82);
        recognizerItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parserType = 1;
            }
        });
        recognizerItem.setSelected(true);
        menu.add(recognizerItem);
        JRadioButtonMenuItem TDParserItem = new JRadioButtonMenuItem("Use Top-Down Parser");
        TDParserItem.setMnemonic(84);
        TDParserItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parserType = 2;
            }
        });
        menu.add(TDParserItem);
        JRadioButtonMenuItem BUParserItem = new JRadioButtonMenuItem("Use Bottom-Up Parser");
        BUParserItem.setMnemonic(66);
        BUParserItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parserType = 3;
            }
        });
        menu.add(BUParserItem);
        JRadioButtonMenuItem chartParserItem = new JRadioButtonMenuItem("Use Top-Down Chart Parser");
        chartParserItem.setMnemonic(67);
        chartParserItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parserType = 4;
            }
        });
        menu.add(chartParserItem);
        ButtonGroup selectParserGroup = new ButtonGroup();
        selectParserGroup.add(recognizerItem);
        selectParserGroup.add(TDParserItem);
        selectParserGroup.add(BUParserItem);
        selectParserGroup.add(chartParserItem);
        final JCheckBoxMenuItem traceItem = new JCheckBoxMenuItem("Parser Trace", parserTrace);
        traceItem.setMnemonic(65);
        traceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                parserTrace = traceItem.getState();
            }
        });
        menu.add(traceItem);
        JMenuItem treeItem = new JMenuItem("Draw Tree");
        treeItem.setMnemonic(69);
        treeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!parses.isEmpty()) {
                    int parseNumber;
                    int parseCount = parses.size();
                    if (parseCount == 1) {
                        parseNumber = 0;
                    } else {
                        Object[] parseNumberVector = new Integer[parseCount];
                        for (int i = 0; i < parseCount; ++i) {
                            parseNumberVector[i] = new Integer(i + 1);
                        }
                        parseNumber = JOptionPane.showOptionDialog(null, "Draw which parse?", "Select a parse", -1, 3, null, parseNumberVector, new Integer(1));
                    }
                    ParseTreeNode parse = (ParseTreeNode)parses.elementAt(parseNumber);
                    if (parse != null) {
                        new ParseView("Parse Tree " + (parseNumber + 1), parse.ann);
                    }
                }
            }
        });
        menu.add(treeItem);
        return menu;
    }
}

