/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.ParseTreeNode;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynFun {
    public static String getImmediateHead(Annotation node) {
        Object pa = node.get("pa");
        if (pa == null) {
            return null;
        }
        return SynFun.headOfPa(pa, node);
    }

    public static String headOfPa(Object pa, Annotation ann) {
        if (pa instanceof FeatureSet) {
            FeatureSet pafs = (FeatureSet)pa;
            Object ohead = pafs.get("head");
            if (!(ohead instanceof String)) {
                System.out.println("headOfPa:  unexpected pa attribute " + pa + " in annotation " + ann);
                return "?";
            }
            String head = (String)ohead;
            String particle = (String)pafs.get("part");
            if (particle != null) {
                return (head + "-" + particle).intern();
            }
            return head.intern();
        }
        if (pa instanceof String) {
            return ((String)pa).intern();
        }
        System.out.println("headOfPa:  unexpected pa attribute " + pa + " in annotation " + ann);
        return "?";
    }

    public static Object getPA(Annotation constit) {
        while (constit != null) {
            Object pa = constit.get("pa");
            if (pa != null) {
                return pa;
            }
            constit = (Annotation)constit.get("headC");
        }
        return null;
    }

    public static String getHead(Document doc, Annotation ann) {
        Object pa = SynFun.getPA(ann);
        if (pa == null) {
            ann = Resolve.getHeadC(ann);
            return Resolve.normalizeName(doc.text(ann)).replace(' ', '-').intern();
        }
        return SynFun.headOfPa(pa, ann);
    }

    public static String getName(Document doc, Annotation constit) {
        Annotation head = Resolve.getHeadC(constit);
        if (head.get("cat") != "name") {
            return null;
        }
        return Resolve.normalizeName(doc.text(head));
    }

    public static String getNameOrHead(Document doc, Annotation ann) {
        String name = SynFun.getName(doc, ann);
        if (name != null) {
            return Resolve.normalizeName(name).replace(' ', '-');
        }
        return SynFun.getHead(doc, ann);
    }

    public static String getDet(Annotation constit) {
        String det = (String)constit.get("det");
        if (det != null) {
            return det;
        }
        Object paObj = constit.get("pa");
        if (!(paObj instanceof FeatureSet)) {
            return null;
        }
        FeatureSet pa = (FeatureSet)paObj;
        if (pa == null) {
            return null;
        }
        if (pa.get("det") instanceof String) {
            return (String)pa.get("det");
        }
        return null;
    }

    public static String getNumber(Annotation constit) {
        Object pa = SynFun.getPA(constit);
        if (pa == null) {
            return null;
        }
        if (pa instanceof FeatureSet) {
            String number = (String)((FeatureSet)pa).get("number");
            if (number == null) {
                return null;
            }
            return number.intern();
        }
        return null;
    }

    public static boolean getHuman(Annotation constit) {
        Object pa = SynFun.getPA(constit);
        if (pa != null && pa instanceof FeatureSet && ((FeatureSet)pa).get("human") != null) {
            return true;
        }
        Annotation headC = Resolve.getHeadC(constit);
        return headC.get("nhuman") != null;
    }

    public static HashMap<Annotation, Annotation> collectParents(Annotation root) {
        HashMap<Annotation, Annotation> parents = new HashMap<Annotation, Annotation>();
        SynFun.collectParents(root, parents);
        return parents;
    }

    private static void collectParents(Annotation node, HashMap<Annotation, Annotation> parents) {
        if (node == null) {
            return;
        }
        Annotation[] children = ParseTreeNode.children(node);
        if (children == null) {
            return;
        }
        for (Annotation child : children) {
            if (child == null) continue;
            parents.put(child, node);
            SynFun.collectParents(child, parents);
        }
    }
}

