/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.parser;

public class SyntacticRelation {
    public String sourceWord;
    public String sourcePos;
    public int sourcePosn;
    public String type;
    public String targetWord;
    public String targetPos;
    public int targetPosn;
    public boolean transparent;
    public String sourceWordSense;

    public SyntacticRelation(int sourcePosn, String sourceWord, String sourcePos, String type, int targetPosn, String targetWord, String targetPos) {
        this.sourcePosn = sourcePosn;
        this.sourceWord = sourceWord;
        this.sourcePos = sourcePos;
        this.type = type;
        this.targetPosn = targetPosn;
        this.targetWord = targetWord;
        this.targetPos = targetPos;
        this.transparent = false;
        this.sourceWordSense = "";
    }

    public SyntacticRelation(int sourcePosn, String sourceWord, String type, int targetPosn, String targetWord) {
        this(sourcePosn, sourceWord, "?", type, targetPosn, targetWord, "?");
    }

    public SyntacticRelation(String s) {
        String[] fields = s.split(" \\| ");
        if (fields.length != 5) {
            System.out.println("SyntacticRelation: invalid constructor argument: " + s);
            return;
        }
        try {
            this.type = fields[0];
            this.sourceWord = fields[1];
            this.sourcePosn = Integer.parseInt(fields[2]);
            this.targetWord = fields[3];
            this.targetPosn = Integer.parseInt(fields[4]);
        }
        catch (NumberFormatException e) {
            System.out.println("SyntacticRelation: invalid numeric in constructor argument: " + s);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyntacticRelation)) {
            return false;
        }
        SyntacticRelation p = (SyntacticRelation)o;
        return this.sourcePosn == p.sourcePosn && this.sourceWord.equals(p.sourceWord) && this.type.equals(p.type) && this.targetPosn == p.targetPosn && this.targetWord.equals(p.targetWord);
    }

    public int hashCode() {
        return (this.sourcePosn + this.sourceWord + this.type + this.targetPosn + this.targetWord).hashCode();
    }

    public void setTransparent(boolean transFlag) {
        this.transparent = transFlag;
    }

    public String toString() {
        return this.sourceWord + " (" + this.sourcePosn + ") " + this.type + " " + this.targetWord + " (" + this.targetPosn + ") ";
    }
}

