/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.Console;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.Action;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;

public class AddFeaturesAction
extends Action {
    FeatureSet features;
    Variable annotationVariable;

    public AddFeaturesAction(FeatureSet fs, Variable sv) {
        this.features = fs;
        this.annotationVariable = sv;
    }

    public AddFeaturesAction(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.nextToken() != 91) {
            throw new PatternSyntaxError("[ expected");
        }
        this.features = new FeatureSet(tok, true, ']');
        if (tok.nextToken() == -3 && tok.sval.equalsIgnoreCase("to")) {
            if (tok.nextToken() != -3 || !Character.isUpperCase(tok.sval.charAt(0))) {
                throw new PatternSyntaxError("variable expected after 'to'");
            }
        } else {
            throw new PatternSyntaxError("'to' expected");
        }
        this.annotationVariable = new Variable(tok.sval);
        tok.nextToken();
    }

    public int perform(Document doc, PatternApplication patap) {
        HashMap bindings = patap.bestBindings;
        Object value = bindings.get(this.annotationVariable.name);
        if (!(value instanceof Annotation)) {
            System.out.println("Value of " + this.annotationVariable.toString() + " is not an annotation");
            return -1;
        }
        Annotation ann = (Annotation)value;
        FeatureSet realFeatures = this.features.substitute(bindings);
        if (Pat.trace) {
            Console.println("Adding features " + realFeatures.toSGMLString() + " to " + ann);
        }
        ann.attributes().putAll(realFeatures);
        return ann.span().end();
    }

    public String toString() {
        return "addFeatures [" + this.features.toSGMLString() + "] to " + this.annotationVariable.toString();
    }
}

