/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.AtomicPatternElement;
import edu.nyu.jet.pat.Pat;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternNode;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.HashMap;
import java.util.Vector;

public class AnnotationPatternElement
extends AtomicPatternElement {
    String type;
    FeatureSet fs;
    Variable v;
    public static boolean hideAnnotations = true;

    public AnnotationPatternElement(String type, FeatureSet fs) {
        this.type = type;
        this.fs = fs;
    }

    public AnnotationPatternElement(String type, FeatureSet fs, Variable v) {
        this.type = type;
        this.fs = fs;
        this.v = v;
    }

    public void eval(Document doc, int posn, String tokenString, HashMap bindings, PatternApplication patap, PatternNode node) {
        Vector<Annotation> posnAnn = doc.annotationsAt(posn);
        if (posnAnn != null) {
            for (Annotation ann : posnAnn) {
                HashMap newbindings;
                if (!ann.type().equals(this.type) || hideAnnotations && ann.get("hidden") != null || (newbindings = Pat.matchFS(ann.attributes(), this.fs, bindings)) == null) continue;
                int ic = ann.span().end();
                if (this.v != null) {
                    newbindings = (HashMap)newbindings.clone();
                    newbindings.put(this.v.name, ann);
                }
                node.eval(doc, ic, newbindings, patap);
            }
        }
    }

    public String toString() {
        return "[" + this.type + this.fs.toSGMLString() + "]";
    }
}

