/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.concepts.Concept;
import edu.nyu.jet.concepts.ConceptHierarchy;
import edu.nyu.jet.pat.PatternSyntaxError;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashSet;

public class FeatureTest {
    String predicate;
    Object argument;
    static HashSet predicateNames = new HashSet();

    public FeatureTest(String predicate, Object argument) {
        this.predicate = predicate;
        this.argument = argument;
    }

    public FeatureTest(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        if (tok.ttype != 63) {
            throw new PatternSyntaxError("? expected");
        }
        if (tok.nextToken() != -3) {
            throw new PatternSyntaxError("predicate name expected");
        }
        this.predicate = tok.sval.intern();
        if (!predicateNames.contains(this.predicate)) {
            throw new PatternSyntaxError("predicate name expected");
        }
        if (tok.nextToken() != 40) {
            throw new PatternSyntaxError("( expected");
        }
        if (tok.nextToken() == -3) {
            String value = tok.sval.intern();
            if (Character.isUpperCase(value.charAt(0))) {
                throw new PatternSyntaxError("Capitalized name (variable) not allowed");
            }
            this.argument = value;
        } else if (tok.ttype == -2) {
            this.argument = new Integer((int)tok.nval);
        } else {
            throw new PatternSyntaxError("symbol or integer expected");
        }
        if (tok.nextToken() != 41) {
            throw new PatternSyntaxError("( expected");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Object value) {
        if (this.predicate == "ne") {
            if (value == this.argument) return false;
            return true;
        }
        if (this.predicate != "isa") return false;
        ConceptHierarchy ch = JetTest.conceptHierarchy;
        if (ch == null) return false;
        if (!(value instanceof String)) return false;
        if (!(this.argument instanceof String)) return false;
        Concept concept1 = ch.getConceptByName((String)this.argument);
        Concept concept2 = ch.getConceptFor((String)value);
        if (concept1 == null) return false;
        if (concept2 == null) return false;
        if (!ConceptHierarchy.isaStar(concept2, concept1)) return false;
        return true;
    }

    static {
        predicateNames.add("ne");
        predicateNames.add("isa");
    }
}

