/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.AtomicPatternElement;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternNode;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.HashMap;

public class IntegerPatternElement
extends AtomicPatternElement {
    Integer min;
    Integer max;
    Variable intvalueVariable;

    public IntegerPatternElement(FeatureSet fs) {
        this.min = (Integer)fs.get("min");
        this.max = (Integer)fs.get("max");
        this.intvalueVariable = (Variable)fs.get("intvalue");
    }

    public void eval(Document doc, int posn, String tokenString, HashMap bindings, PatternApplication patap, PatternNode node) {
        Annotation token = doc.tokenAt(posn);
        if (token == null) {
            return;
        }
        Integer value = (Integer)token.get("intvalue");
        if (value == null) {
            return;
        }
        if (this.min != null && value < this.min) {
            return;
        }
        if (this.max != null && value > this.max) {
            return;
        }
        int ic = token.span().end();
        if (this.intvalueVariable != null) {
            bindings = (HashMap)bindings.clone();
            bindings.put(this.intvalueVariable.name, value);
        }
        node.eval(doc, ic, bindings, patap);
    }

    public String toString() {
        String result = "[integer";
        if (this.min != null) {
            result = result + "min = " + this.min;
        }
        if (this.max != null) {
            result = result + "max = " + this.max;
        }
        result = result + "]";
        return result;
    }
}

