/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.pat.Id;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternArc;
import edu.nyu.jet.pat.PatternNode;
import edu.nyu.jet.pat.PatternSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class InternalPatternNode
extends PatternNode {
    public PatternArc[] arcs;

    public InternalPatternNode(Id i, PatternArc[] a) {
        this.id = i;
        this.arcs = a;
    }

    public InternalPatternNode(Id i, Vector a) {
        this.id = i;
        this.arcs = a.toArray(new PatternArc[0]);
    }

    public void eval(Document doc, int posn, HashMap bindings, PatternApplication patap) {
        if (posn > PatternSet.limit) {
            return;
        }
        Annotation token = doc.tokenAt(posn);
        String tokenString = token == null ? null : doc.text(token).trim().intern();
        for (int i = 0; i < this.arcs.length; ++i) {
            this.arcs[i].eval(doc, posn, tokenString, bindings, patap);
        }
    }

    public String toString() {
        String result = "";
        if (this.arcs.length == 1) {
            result = result + this.arcs[0].pe.toString() + " " + this.arcs[0].target.id.value;
            if (!this.arcs[0].target.visited()) {
                this.arcs[0].target.visit();
                result = result + " " + this.arcs[0].target.toString();
            }
        } else if (this.arcs.length > 1) {
            result = result + "(" + this.arcs[0].pe.toString() + " " + this.arcs[0].target.id.value;
            if (!this.arcs[0].target.visited()) {
                this.arcs[0].target.visit();
                result = result + " " + this.arcs[0].target.toString();
            }
            for (int i = 1; i < this.arcs.length; ++i) {
                result = result + " | " + this.arcs[i].pe.toString() + " " + this.arcs[i].target.id.value;
                if (this.arcs[i].target.visited()) continue;
                this.arcs[i].target.visit();
                result = result + " " + this.arcs[i].target.toString();
            }
            result = result + ")";
        }
        return result;
    }

    public void toTree(DefaultMutableTreeNode parent) {
        for (int i = 0; i < this.arcs.length; ++i) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(this.arcs[i].pe.toString() + " NODE_" + this.arcs[i].target.id.value);
            parent.add(child);
            if (this.arcs[i].target.visited()) continue;
            this.arcs[i].target.visit();
            this.arcs[i].target.toTree(child);
        }
    }
}

