/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.Console;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.pat.Action;
import edu.nyu.jet.pat.PatternCollection;
import edu.nyu.jet.pat.PatternRule;
import edu.nyu.jet.pat.PatternSet;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class PatternApplication {
    public boolean matchFound = false;
    Document document;
    public int startPosition;
    public int bestPosition;
    public String bestPatternName;
    public HashMap bestBindings;
    public Vector bestActions;
    public static boolean patternMatchTrace = false;
    public static boolean patternApplyTrace = false;
    private static Hashtable matchTracedPatterns = new Hashtable();
    private static Hashtable applyTracedPatterns = new Hashtable();
    private static JCheckBoxMenuItem item;
    private static String patternName;
    private static String patternSetName;
    private static JMenu matchSubmenu;
    private static JMenu applySubmenu;
    private static int numOfPatterns;
    private static int numOfApplyPatterns;
    private static PatternCollection pc;
    private static PatternSet ps;
    private static PatternRule pr;

    public PatternApplication(Document doc, int start) {
        this.document = doc;
        this.startPosition = start;
        this.bestPosition = -1;
    }

    public void recordMatch(int position, String patternName, HashMap bindings, Vector actions) {
        Object name = matchTracedPatterns.get(patternName);
        if (name != null && name.equals("true")) {
            Console.println("Matched pattern " + patternName + " over " + this.document.text(new Span(this.startPosition, position)));
            if (Console.pv != null) {
                Console.pv.addMatchedPattern(patternName);
                Console.pv.refresh();
            }
        }
        if (position > this.bestPosition) {
            this.matchFound = true;
            this.bestPosition = position;
            this.bestPatternName = patternName;
            this.bestBindings = bindings;
            this.bestActions = actions;
        }
    }

    public int performActions() {
        if (this.matchFound) {
            int furthestPositionAnnotated = -1;
            Object name = applyTracedPatterns.get(this.bestPatternName);
            if (name != null && name.equals("true")) {
                Console.println("Applying pattern " + this.bestPatternName + " over " + this.document.text(new Span(this.startPosition, this.bestPosition)));
                if (Console.pv != null) {
                    Console.pv.addAppliedPattern(this.bestPatternName);
                    Console.pv.refresh();
                }
            }
            for (int i = 0; i < this.bestActions.size(); ++i) {
                Action act = (Action)this.bestActions.get(i);
                furthestPositionAnnotated = Math.max(furthestPositionAnnotated, act.perform(this.document, this));
            }
            return furthestPositionAnnotated;
        }
        return -1;
    }

    public static JMenu patternMenu() {
        JMenu menu = new JMenu("Patterns");
        menu.setMnemonic(80);
        final JCheckBoxMenuItem matchTraceItem = new JCheckBoxMenuItem("Pattern Match Trace", patternMatchTrace);
        matchTraceItem.setMnemonic(77);
        matchTraceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                patternMatchTrace = matchTraceItem.getState();
            }
        });
        menu.add(matchTraceItem);
        final JCheckBoxMenuItem applyTraceItem = new JCheckBoxMenuItem("Pattern Apply Trace", patternApplyTrace);
        applyTraceItem.setMnemonic(65);
        applyTraceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                patternApplyTrace = applyTraceItem.getState();
            }
        });
        menu.add(applyTraceItem);
        return menu;
    }

    public static JMenu matchSubmenu() {
        pc = JetTest.pc;
        numOfPatterns = PatternApplication.pc.patternNames.size();
        matchSubmenu = new JMenu("Pattern Match Trace");
        matchSubmenu.setMnemonic(77);
        item = new JCheckBoxMenuItem("All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    for (int i = 2; i < numOfPatterns + 2; ++i) {
                        JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)matchSubmenu.getItem(i);
                        jcbmi.setState(true);
                        matchTracedPatterns.put(jcbmi.getText(), "true");
                    }
                } else {
                    for (int i = 2; i < numOfPatterns + 2; ++i) {
                        JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)matchSubmenu.getItem(i);
                        jcbmi.setState(false);
                        matchTracedPatterns.put(jcbmi.getText(), "false");
                    }
                }
            }
        });
        matchSubmenu.add(item);
        matchSubmenu.addSeparator();
        for (int i = 0; i < numOfPatterns; ++i) {
            patternName = (String)PatternApplication.pc.patternNames.get(i);
            item = new JCheckBoxMenuItem(patternName);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                        matchTracedPatterns.put(e.getActionCommand(), "true");
                    } else {
                        matchTracedPatterns.put(e.getActionCommand(), "false");
                        JCheckBoxMenuItem all = (JCheckBoxMenuItem)matchSubmenu.getItem(0);
                        all.setState(false);
                    }
                }
            });
            matchSubmenu.add(item);
        }
        return matchSubmenu;
    }

    public static JMenu applySubmenu() {
        pc = JetTest.pc;
        numOfApplyPatterns = 0;
        applySubmenu = new JMenu("Pattern Apply Trace");
        applySubmenu.setMnemonic(65);
        item = new JCheckBoxMenuItem("All");
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    for (int i = 2; i < numOfApplyPatterns + 2; ++i) {
                        JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)applySubmenu.getItem(i);
                        jcbmi.setState(true);
                        applyTracedPatterns.put(jcbmi.getText(), "true");
                    }
                } else {
                    for (int i = 2; i < numOfApplyPatterns + 2; ++i) {
                        JCheckBoxMenuItem jcbmi = (JCheckBoxMenuItem)applySubmenu.getItem(i);
                        jcbmi.setState(false);
                        applyTracedPatterns.put(jcbmi.getText(), "false");
                    }
                }
            }
        });
        applySubmenu.add(item);
        applySubmenu.addSeparator();
        for (int i = 0; i < PatternApplication.pc.patternSetNames.size(); ++i) {
            patternSetName = (String)PatternApplication.pc.patternSetNames.get(i);
            ps = (PatternSet)PatternApplication.pc.patternSets.get(patternSetName);
            for (int j = 0; j < PatternApplication.ps.rules.size(); ++j) {
                pr = (PatternRule)PatternApplication.ps.rules.get(j);
                item = new JCheckBoxMenuItem(PatternApplication.pr.patternName);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                            applyTracedPatterns.put(e.getActionCommand(), "true");
                        } else {
                            applyTracedPatterns.put(e.getActionCommand(), "false");
                            JCheckBoxMenuItem all = (JCheckBoxMenuItem)applySubmenu.getItem(0);
                            all.setState(false);
                        }
                    }
                });
                applySubmenu.add(item);
            }
            numOfApplyPatterns += PatternApplication.ps.rules.size();
        }
        return applySubmenu;
    }
}

