/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.concepts.ConcreteFileFilter;
import edu.nyu.jet.pat.PatternCollection;
import edu.nyu.jet.pat.PatternSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class PatternGraphView
extends JFrame
implements ActionListener {
    PatternCollection pc;
    JTree patternGraphTree;
    JScrollPane jScrollPane = new JScrollPane();
    JFileChooser fc = new JFileChooser(".");
    File currentFile;

    public PatternGraphView(File file) {
        this.currentFile = file;
        this.readPatterns();
        this.buildTree();
        this.jbInit();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Open ...")) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.currentFile = this.fc.getSelectedFile();
                this.readPatterns();
                this.buildTree();
                this.patternGraphTree.getSelectionModel().setSelectionMode(1);
                this.jScrollPane.getViewport().add((Component)this.patternGraphTree, null);
                this.setTitle("Pattern Graph View - " + this.currentFile.getPath());
            }
        } else if (e.getActionCommand().equals("Expand")) {
            TreePath path = this.patternGraphTree.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.expand(root);
            }
        } else if (e.getActionCommand().equals("Collapse")) {
            TreePath path = this.patternGraphTree.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.collapse(root);
            }
        } else if (e.getActionCommand().equals("Expand All")) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.patternGraphTree.getModel().getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.expand((DefaultMutableTreeNode)root.getChildAt(i));
            }
        } else if (e.getActionCommand().equals("Collapse All")) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.patternGraphTree.getModel().getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.collapse((DefaultMutableTreeNode)root.getChildAt(i));
            }
        } else {
            this.dispose();
        }
    }

    private void buildTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Pattern Sets");
        this.patternGraphTree = new JTree(root);
        this.patternGraphTree.setRootVisible(true);
        this.patternGraphTree.setShowsRootHandles(true);
        this.patternGraphTree.setEditable(false);
        this.patternGraphTree.putClientProperty("JTree.lineStyle", "Angled");
        this.patternGraphTree.setCellRenderer(new PatternGraphRenderer());
        for (int i = 0; i < this.pc.patternSetNames.size(); ++i) {
            String name = (String)this.pc.patternSetNames.get(i);
            DefaultMutableTreeNode child = new DefaultMutableTreeNode("Pattern Set: " + name);
            root.add(child);
            DefaultMutableTreeNode parent = child;
            child = new DefaultMutableTreeNode("NODE_0");
            parent.add(child);
            parent = child;
            PatternSet ps = (PatternSet)this.pc.patternSets.get(name);
            ps.rootNode.toTree(parent);
        }
        this.patternGraphTree.updateUI();
    }

    private void readPatterns() {
        this.pc = new PatternCollection();
        try {
            this.pc.readPatternCollection(new BufferedReader(new FileReader(this.currentFile)));
        }
        catch (IOException e) {
            System.err.println("Error: reading pattern file " + this.currentFile.getName() + ", " + e.getMessage());
        }
        this.pc.makePatternGraph();
    }

    private void expand(DefaultMutableTreeNode root) {
        this.patternGraphTree.expandPath(new TreePath(root.getPath()));
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.expand((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private void collapse(DefaultMutableTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.collapse((DefaultMutableTreeNode)root.getChildAt(i));
        }
        this.patternGraphTree.collapsePath(new TreePath(root.getPath()));
    }

    private void jbInit() {
        JMenuBar jmb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Open ...");
        item.setMnemonic(79);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(item);
        item.addActionListener(this);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic(88);
        fileMenu.add(item);
        item.addActionListener(this);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        item = new JMenuItem("Expand");
        item.setMnemonic(69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Collapse");
        item.setMnemonic(67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Expand All");
        item.setMnemonic(69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Collapse All");
        item.setMnemonic(67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        viewMenu.add(item);
        item.addActionListener(this);
        jmb.add(fileMenu);
        jmb.add(viewMenu);
        this.setJMenuBar(jmb);
        ConcreteFileFilter filter = new ConcreteFileFilter("pat", "Pattern Files (*.pat)");
        this.fc.setFileFilter(filter);
        this.fc.setDialogTitle("Open Pattern File");
        this.fc.setApproveButtonText("Open");
        this.fc.setApproveButtonMnemonic(79);
        this.fc.setApproveButtonToolTipText("Open Pattern File");
        this.patternGraphTree.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)this.patternGraphTree, null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(600, 600);
        this.setTitle("Pattern Graph View - " + this.currentFile.getPath());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PatternGraphView.this.dispose();
            }
        });
    }

    class PatternGraphRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon actionIcon = new ImageIcon("images/fish.gif");

        PatternGraphRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && this.isAction(value)) {
                this.setIcon(this.actionIcon);
            }
            return this;
        }

        boolean isAction(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String info = (String)node.getUserObject();
            return info.indexOf("-->") >= 0;
        }
    }
}

