/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.pat.Id;
import edu.nyu.jet.pat.InternalPatternNode;
import edu.nyu.jet.pat.NullPatternElement;
import edu.nyu.jet.pat.PatternArc;
import edu.nyu.jet.pat.PatternElement;
import edu.nyu.jet.pat.PatternGraph;
import java.util.Vector;

public class PatternRepetition
extends PatternElement {
    PatternElement element;
    char repetition;

    public PatternRepetition(PatternElement pe, char rep) {
        this.element = pe;
        this.repetition = rep;
    }

    public String toString() {
        return "(" + this.element.toString() + ")" + this.repetition;
    }

    public PatternGraph toGraph(Id id) {
        PatternGraph elementGraph = this.element.toGraph(id);
        Vector<PatternArc> inEdges = new Vector<PatternArc>(elementGraph.inEdges);
        Vector<PatternArc> outEdges = new Vector<PatternArc>(elementGraph.outEdges);
        switch (this.repetition) {
            case '?': {
                PatternArc nullArc = new PatternArc(new NullPatternElement(), null);
                inEdges.add(nullArc);
                outEdges.add(nullArc);
                return new PatternGraph(inEdges, outEdges);
            }
            case '*': {
                PatternArc nullArc2 = new PatternArc(new NullPatternElement(), null);
                inEdges.add(nullArc2);
                InternalPatternNode node = new InternalPatternNode(new Id(id.value++), inEdges);
                elementGraph.setOutEdges(node);
                PatternArc nullArc1 = new PatternArc(new NullPatternElement(), node);
                Vector<PatternArc> newInEdges = new Vector<PatternArc>(1);
                Vector<PatternArc> newOutEdges = new Vector<PatternArc>(1);
                newInEdges.add(nullArc1);
                newOutEdges.add(nullArc2);
                return new PatternGraph(newInEdges, newOutEdges);
            }
            case '+': {
                PatternArc nullArc = new PatternArc(new NullPatternElement(), null);
                inEdges.add(nullArc);
                InternalPatternNode node = new InternalPatternNode(new Id(id.value++), inEdges);
                elementGraph.setOutEdges(node);
                Vector<PatternArc> newOutEdges = new Vector<PatternArc>(1);
                newOutEdges.add(nullArc);
                PatternGraph elementGraph2 = this.element.toGraph(id);
                elementGraph2.setOutEdges(node);
                return new PatternGraph(elementGraph2.inEdges, newOutEdges);
            }
        }
        System.out.println("Invalid repetition character " + this.repetition);
        return elementGraph;
    }
}

