/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.pat.Id;
import edu.nyu.jet.pat.InternalPatternNode;
import edu.nyu.jet.pat.PatternElement;
import edu.nyu.jet.pat.PatternGraph;
import java.util.Vector;

public class PatternSequence
extends PatternElement {
    PatternElement[] elements;

    public PatternSequence(PatternElement[] elems) {
        this.elements = elems;
    }

    public PatternSequence(Vector elems) {
        this.elements = elems.toArray(new PatternElement[0]);
    }

    public String toString() {
        String stg = "";
        for (int i = 0; i < this.elements.length; ++i) {
            if (i > 0) {
                stg = stg + " ";
            }
            stg = stg + this.elements[i].toString();
        }
        return stg;
    }

    public PatternGraph toGraph(Id id) {
        PatternGraph[] elementGraph = new PatternGraph[this.elements.length + 1];
        for (int i = 0; i < this.elements.length; ++i) {
            elementGraph[i] = this.elements[i].toGraph(id);
            if (i <= 0) continue;
            InternalPatternNode node = new InternalPatternNode(new Id(id.value++), elementGraph[i].inEdgeArray());
            elementGraph[i - 1].setOutEdges(node);
        }
        return new PatternGraph(elementGraph[0].inEdges, elementGraph[this.elements.length - 1].outEdges);
    }
}

