/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.concepts.ConcreteFileFilter;
import edu.nyu.jet.pat.Action;
import edu.nyu.jet.pat.PatternAlternation;
import edu.nyu.jet.pat.PatternCollection;
import edu.nyu.jet.pat.PatternElement;
import edu.nyu.jet.pat.PatternRule;
import edu.nyu.jet.pat.PatternSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PatternView
extends JFrame
implements ActionListener {
    PatternCollection pc;
    DefaultMutableTreeNode patternsNode;
    DefaultMutableTreeNode patternSetsNode;
    JTree patternTree;
    JScrollPane jScrollPane = new JScrollPane();
    JFileChooser fc = new JFileChooser(".");
    File currentFile;
    Vector matchedPatterns = new Vector();
    Vector appliedPatterns = new Vector();

    public PatternView(File file) {
        this.currentFile = file;
        this.readPatterns();
        this.buildTree();
        this.jbInit();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Open ...")) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.currentFile = this.fc.getSelectedFile();
                this.readPatterns();
                this.buildTree();
                this.patternTree.getSelectionModel().setSelectionMode(1);
                this.jScrollPane.getViewport().add((Component)this.patternTree, null);
                this.setTitle("Pattern View - " + this.currentFile.getPath());
            }
        } else if (e.getActionCommand().equals("Expand")) {
            TreePath path = this.patternTree.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.expand(root);
            }
        } else if (e.getActionCommand().equals("Collapse")) {
            TreePath path = this.patternTree.getSelectionPath();
            if (path != null) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)path.getLastPathComponent();
                this.collapse(root);
            }
        } else if (e.getActionCommand().equals("Expand All")) {
            this.expand(this.patternsNode);
            this.expand(this.patternSetsNode);
        } else if (e.getActionCommand().equals("Collapse All")) {
            this.collapse(this.patternsNode);
            this.collapse(this.patternSetsNode);
        } else if (e.getActionCommand().equals("Clear Marks")) {
            this.clearMatchedPatterns();
            this.clearAppliedPatterns();
            this.refresh();
        } else {
            this.dispose();
        }
    }

    public void addMatchedPattern(String pattern) {
        this.matchedPatterns.add(pattern);
    }

    public void clearMatchedPatterns() {
        this.matchedPatterns = new Vector();
    }

    public void addAppliedPattern(String pattern) {
        this.appliedPatterns.add(pattern);
    }

    public void clearAppliedPatterns() {
        this.appliedPatterns = new Vector();
    }

    public void refresh() {
        this.patternTree.updateUI();
    }

    private void buildTree() {
        int j;
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode child;
        String name;
        int i;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        this.patternTree = new JTree(root);
        this.patternTree.setRootVisible(false);
        this.patternTree.setShowsRootHandles(true);
        this.patternTree.setEditable(false);
        this.patternTree.putClientProperty("JTree.lineStyle", "Angled");
        this.patternTree.setCellRenderer(new PatternRenderer());
        this.patternsNode = new DefaultMutableTreeNode("Patterns");
        this.patternSetsNode = new DefaultMutableTreeNode("Pattern Sets");
        root.add(this.patternsNode);
        root.add(this.patternSetsNode);
        for (i = 0; i < this.pc.patternNames.size(); ++i) {
            name = (String)this.pc.patternNames.get(i);
            child = new DefaultMutableTreeNode(name);
            this.patternsNode.add(child);
            parent = child;
            PatternElement pe = (PatternElement)this.pc.patterns.get(name);
            if (pe instanceof PatternAlternation) {
                PatternAlternation pa = (PatternAlternation)pe;
                for (j = 0; j < pa.options.length; ++j) {
                    child = new DefaultMutableTreeNode(pa.options[j].toString());
                    parent.add(child);
                }
                continue;
            }
            child = new DefaultMutableTreeNode(pe.toString());
            parent.add(child);
        }
        for (i = 0; i < this.pc.patternSetNames.size(); ++i) {
            name = (String)this.pc.patternSetNames.get(i);
            child = new DefaultMutableTreeNode("Pattern Set: " + name);
            this.patternSetsNode.add(child);
            parent = child;
            PatternSet ps = (PatternSet)this.pc.patternSets.get(name);
            for (j = 0; j < ps.rules.size(); ++j) {
                PatternRule pr = (PatternRule)ps.rules.get(j);
                child = new DefaultMutableTreeNode(pr.patternName);
                parent.add(child);
                for (int k = 0; k < pr.actions().size(); ++k) {
                    Action action = (Action)pr.actions().get(k);
                    child.add(new DefaultMutableTreeNode(action));
                }
            }
        }
        this.patternTree.updateUI();
    }

    private void readPatterns() {
        this.pc = new PatternCollection();
        try {
            this.pc.readPatternCollection(new BufferedReader(new FileReader(this.currentFile)));
        }
        catch (IOException e) {
            System.err.println("Error: reading pattern file " + this.currentFile.getName() + ", " + e.getMessage());
        }
        this.pc.makePatternGraph();
    }

    private void expand(DefaultMutableTreeNode root) {
        this.patternTree.expandPath(new TreePath(root.getPath()));
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.expand((DefaultMutableTreeNode)root.getChildAt(i));
        }
    }

    private void collapse(DefaultMutableTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.collapse((DefaultMutableTreeNode)root.getChildAt(i));
        }
        this.patternTree.collapsePath(new TreePath(root.getPath()));
    }

    private void jbInit() {
        JMenuBar jmb = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem item = new JMenuItem("Open ...");
        item.setMnemonic(79);
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        fileMenu.add(item);
        item.addActionListener(this);
        fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic(88);
        fileMenu.add(item);
        item.addActionListener(this);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(86);
        item = new JMenuItem("Expand");
        item.setMnemonic(69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Collapse");
        item.setMnemonic(67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Expand All");
        item.setMnemonic(69);
        item.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        viewMenu.add(item);
        item.addActionListener(this);
        item = new JMenuItem("Collapse All");
        item.setMnemonic(67);
        item.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        viewMenu.add(item);
        item.addActionListener(this);
        viewMenu.addSeparator();
        item = new JMenuItem("Clear Marks");
        item.setMnemonic(77);
        item.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        viewMenu.add(item);
        item.addActionListener(this);
        jmb.add(fileMenu);
        jmb.add(viewMenu);
        this.setJMenuBar(jmb);
        ConcreteFileFilter filter = new ConcreteFileFilter("pat", "Pattern Files (*.pat)");
        this.fc.setFileFilter(filter);
        this.fc.setDialogTitle("Open Pattern File");
        this.fc.setApproveButtonText("Open");
        this.fc.setApproveButtonMnemonic(79);
        this.fc.setApproveButtonToolTipText("Open Pattern File");
        this.patternTree.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)this.patternTree, null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(600, 600);
        this.setTitle("Pattern View - " + this.currentFile.getPath());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PatternView.this.dispose();
            }
        });
    }

    class PatternRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon actionIcon = new ImageIcon("images/fish.gif");
        ImageIcon matchIcon = new ImageIcon("images/octopus.gif");
        ImageIcon applyIcon = new ImageIcon("images/crab.gif");

        PatternRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf && this.isAction(value)) {
                this.setIcon(this.actionIcon);
            } else if (!leaf && this.isMatched(value)) {
                this.setIcon(this.matchIcon);
            } else if (!leaf && this.isApplied(value)) {
                this.setIcon(this.applyIcon);
            }
            return this;
        }

        boolean isAction(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            TreeNode[] path = node.getPath();
            for (int i = 0; i < path.length; ++i) {
                if (!((DefaultMutableTreeNode)path[i]).equals(PatternView.this.patternSetsNode)) continue;
                return true;
            }
            return false;
        }

        boolean isMatched(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String info = node.getUserObject().toString();
            if (!PatternView.this.matchedPatterns.contains(info)) {
                return false;
            }
            TreeNode[] path = node.getPath();
            for (int i = 0; i < path.length; ++i) {
                if (!((DefaultMutableTreeNode)path[i]).equals(PatternView.this.patternsNode)) continue;
                return true;
            }
            return false;
        }

        boolean isApplied(Object value) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            String info = node.getUserObject().toString();
            if (!PatternView.this.appliedPatterns.contains(info)) {
                return false;
            }
            TreeNode[] path = node.getPath();
            for (int i = 0; i < path.length; ++i) {
                if (!((DefaultMutableTreeNode)path[i]).equals(PatternView.this.patternSetsNode)) continue;
                return true;
            }
            return false;
        }
    }
}

