/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.pat;

import edu.nyu.jet.lisp.Variable;
import edu.nyu.jet.pat.PatternApplication;
import edu.nyu.jet.pat.PatternSyntaxError;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Vector;

public class StringExpression {
    Vector elements = new Vector();

    public StringExpression(StreamTokenizer tok) throws IOException, PatternSyntaxError {
        while (true) {
            if (tok.ttype == 34) {
                String stg = tok.sval;
                this.elements.addElement(stg);
            } else if (tok.ttype == -3 && Character.isUpperCase(tok.sval.charAt(0))) {
                String variable = tok.sval;
                this.elements.addElement(new Variable(variable));
            } else {
                throw new PatternSyntaxError("invalid print/write expression");
            }
            if (tok.nextToken() != 43) {
                return;
            }
            tok.nextToken();
        }
    }

    public String evaluate(Document doc, PatternApplication patap) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            Object element = this.elements.elementAt(i);
            if (element instanceof String) {
                sb.append((String)element);
                continue;
            }
            if (element instanceof Variable) {
                Variable var = (Variable)element;
                HashMap bindings = patap.bestBindings;
                Object value = bindings.get(var.name);
                if (value instanceof Span) {
                    Span span = (Span)value;
                    sb.append(this.cleanWhitespace(doc.text(span)));
                    continue;
                }
                if (value instanceof Annotation) {
                    Annotation annotation = (Annotation)value;
                    sb.append(this.cleanWhitespace(doc.text(annotation)));
                    continue;
                }
                sb.append(" ? ");
                continue;
            }
            throw new Error("invalid element in StringExpression");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            Object element;
            if (i > 0) {
                sb.append(" + ");
            }
            if ((element = this.elements.elementAt(i)) instanceof String) {
                sb.append("\"" + (String)element + "\"");
                continue;
            }
            if (element instanceof Variable) {
                Variable var = (Variable)element;
                sb.append(var.toString());
                continue;
            }
            throw new Error("invalid element in StringExpression");
        }
        return sb.toString();
    }

    private String cleanWhitespace(String in) {
        StringBuffer sb = new StringBuffer(in);
        for (int i = 0; i < sb.length(); ++i) {
            if (!Character.isWhitespace(sb.charAt(i))) continue;
            sb.setCharAt(i, ' ');
        }
        return sb.toString();
    }
}

