/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Console;
import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.Validate;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.CorefScorer;
import edu.nyu.jet.refres.DocumentScorer;
import edu.nyu.jet.refres.PronounScorer;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.CollectionView;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import java.io.IOException;

public class CorefEval {
    static final String collection = "coref/training nwire sgm.txt";
    static final String keyCollection = "coref/training nwire coref.txt";
    static final String parseCollection = "coref/training nwire parses.txt";
    static final String baselineCollection = "temp/coref/coref baseline.txt";
    static final boolean writeBaseline = false;
    static final boolean compareToBaseline = false;
    static final boolean useParser = true;
    static final boolean useParseCollection = true;
    static final boolean onlyPronouns = true;

    public static void main(String[] args) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace 05 use parses.properties");
        new Console();
        EDTtype.readTypeDict();
        Resolve.ACE = true;
        Resolve.useMaxEnt = true;
        DocumentCollection col = new DocumentCollection(parseCollection);
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        col.open();
        keyCol.open();
        PronounScorer scorer = new PronounScorer();
        for (int docCount = 0; docCount < col.size(); ++docCount) {
            ExternalDocument doc = col.get(docCount);
            System.out.println("\nProcessing document " + docCount + ": " + doc.fileName());
            Console.println("\nProcessing document " + docCount + ": " + doc.fileName());
            doc.setAllTags(true);
            doc.open();
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, docCount == -1, docCount);
            Ace.tagReciprocalRelations(doc);
            ExternalDocument keyDoc = keyCol.get(docCount);
            keyDoc.setAllTags(true);
            keyDoc.open();
            keyDoc.stretch("mention");
            CorefFilter.buildEntitiesFromMentions(keyDoc);
            ((DocumentScorer)scorer).score(doc, keyDoc);
            ((DocumentScorer)scorer).report();
        }
        ((DocumentScorer)scorer).summary();
        new CollectionView(col);
    }

    public static void task(String[] args) {
        if (args.length != 3) {
            System.out.println("CorefEval requires 2 arguments: jet -CorefEval <response collection> <key collection>");
            System.exit(1);
        }
        String collection = args[1];
        String keyCollection = args[2];
        DocumentCollection col = new DocumentCollection(collection);
        DocumentCollection keyCol = new DocumentCollection(keyCollection);
        col.open();
        keyCol.open();
        CorefScorer scorer = new CorefScorer();
        for (int docCount = 0; docCount < col.size(); ++docCount) {
            ExternalDocument doc = col.get(docCount);
            System.out.println("\nProcessing document " + docCount + ": " + doc.fileName());
            doc.setAllTags(true);
            doc.open();
            ExternalDocument keyDoc = keyCol.get(docCount);
            keyDoc.setAllTags(true);
            keyDoc.open();
            CorefFilter.buildEntitiesFromMentions(doc);
            CorefFilter.buildEntitiesFromMentions(keyDoc);
            scorer.score(doc, keyDoc);
            scorer.report();
        }
        scorer.summary();
        float FO = 2.0f / (1.0f / scorer.overallRecall + 1.0f / scorer.overallPrecision);
        Validate.score = FO;
    }
}

