/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.DocumentScorer;
import edu.nyu.jet.refres.EntityView;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class CorefScorer
extends DocumentScorer {
    private Document responseDoc;
    private Document keyDoc;
    private HashMap responseToKeyMentionMap;
    private HashMap keyToResponseMentionMap;
    private Vector responseEntities;
    private Vector keyEntities;
    private HashMap responseMentionToEntityMap;
    private HashMap keyMentionToEntityMap;
    public float recall;
    public float precision;
    public float overallRecall;
    public float overallPrecision;
    public int mappedMentionCount = 0;
    public int overallMappedMentionCount = 0;
    private int recallNumerator = 0;
    private int recallDenominator = 0;
    private int precisionNumerator = 0;
    private int precisionDenominator = 0;
    private int scoreNumerator;
    private int scoreDenominator;

    public void score(Document responseDoc, Document keyDoc) {
        this.responseDoc = responseDoc;
        this.keyDoc = keyDoc;
        this.mappedMentionCount = 0;
        this.alignMentions();
        this.responseEntities = responseDoc.annotationsOfType("entity");
        if (this.responseEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in response");
            return;
        }
        this.keyEntities = keyDoc.annotationsOfType("entity");
        if (this.keyEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in key");
            return;
        }
        this.responseMentionToEntityMap = this.buildMentionToEntityMap(responseDoc, this.responseEntities);
        this.keyMentionToEntityMap = this.buildMentionToEntityMap(keyDoc, this.keyEntities);
        this.precision = this.scoreEntities(this.responseEntities, this.responseToKeyMentionMap, this.keyMentionToEntityMap, true);
        this.recall = this.scoreEntities(this.keyEntities, this.keyToResponseMentionMap, this.responseMentionToEntityMap, false);
        this.overallPrecision = (float)this.precisionNumerator / (float)this.precisionDenominator;
        this.overallRecall = (float)this.recallNumerator / (float)this.recallDenominator;
        this.overallMappedMentionCount += this.mappedMentionCount;
    }

    private void alignMentions() {
        HashMap endOfKeyMentionMap = CorefScorer.buildEndOfMentionMap(this.keyDoc);
        this.responseToKeyMentionMap = new HashMap();
        this.keyToResponseMentionMap = new HashMap();
        Vector responseMentions = CorefScorer.findMentions(this.responseDoc);
        if (responseMentions != null) {
            for (int j = 0; j < responseMentions.size(); ++j) {
                Annotation responseMention = (Annotation)responseMentions.elementAt(j);
                Annotation responseMentionHead = Resolve.getHeadC(responseMention);
                int end = responseMentionHead.span().end();
                Annotation keyMention = (Annotation)endOfKeyMentionMap.get(new Integer(end));
                if (keyMention == null) continue;
                this.responseToKeyMentionMap.put(responseMention, keyMention);
                this.keyToResponseMentionMap.put(keyMention, responseMention);
                ++this.mappedMentionCount;
            }
        }
    }

    static HashMap buildEndOfMentionMap(Document doc) {
        HashMap<Integer, Annotation> endOfMentionMap = new HashMap<Integer, Annotation>();
        Vector mentions = CorefScorer.findMentions(doc);
        if (mentions != null) {
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = (Annotation)mentions.elementAt(j);
                Annotation mentionHead = Resolve.getHeadC(mention);
                int end = mentionHead.span().end();
                endOfMentionMap.put(new Integer(end), mention);
            }
        }
        return endOfMentionMap;
    }

    public static Vector findMentions(Document doc) {
        Vector mentions = new Vector();
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        if (entities != null) {
            for (int j = 0; j < entities.size(); ++j) {
                Annotation entity = entities.get(j);
                Vector mentionsOfEntity = (Vector)entity.get("mentions");
                mentions.addAll(mentionsOfEntity);
            }
        }
        return mentions;
    }

    private HashMap buildMentionToEntityMap(Document doc, Vector entities) {
        HashMap<Annotation, Annotation> map = new HashMap<Annotation, Annotation>();
        for (int i = 0; i < entities.size(); ++i) {
            Annotation entity = (Annotation)entities.get(i);
            Vector mentions = (Vector)entity.get("mentions");
            if (mentions == null) {
                System.err.println("(buildMentionToEntityMap) entity with no mentions");
                return null;
            }
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = (Annotation)mentions.get(j);
                map.put(mention, entity);
            }
        }
        return map;
    }

    private float scoreEntities(Vector entities, HashMap mentionMap, HashMap mentionToEntityMap, boolean precision) {
        this.scoreNumerator = 0;
        this.scoreDenominator = 0;
        for (int i = 0; i < entities.size(); ++i) {
            Annotation entity = (Annotation)entities.get(i);
            this.scoreEntity(entity, mentionMap, mentionToEntityMap);
        }
        if (precision) {
            this.precisionNumerator += this.scoreNumerator;
            this.precisionDenominator += this.scoreDenominator;
        } else {
            this.recallNumerator += this.scoreNumerator;
            this.recallDenominator += this.scoreDenominator;
        }
        return (float)this.scoreNumerator / (float)this.scoreDenominator;
    }

    private void scoreEntity(Annotation entity1, HashMap mentionMap, HashMap mentionToEntityMap) {
        Vector mentions1 = (Vector)entity1.get("mentions");
        int unmappedMentionsInEntity = 0;
        int mappedMentionsInEntity = 0;
        HashSet<Annotation> mappedEntities = new HashSet<Annotation>();
        for (int i = 0; i < mentions1.size(); ++i) {
            Annotation mention1 = (Annotation)mentions1.get(i);
            Annotation mention2 = (Annotation)mentionMap.get(mention1);
            if (mention2 == null) {
                ++unmappedMentionsInEntity;
                continue;
            }
            ++mappedMentionsInEntity;
            Annotation entity2 = (Annotation)mentionToEntityMap.get(mention2);
            mappedEntities.add(entity2);
        }
        if (mappedMentionsInEntity > 0) {
            this.scoreNumerator += mappedMentionsInEntity - mappedEntities.size();
            this.scoreDenominator += mappedMentionsInEntity - 1;
        }
    }

    public void report() {
        System.out.println("Recall = " + this.recall);
        System.out.println("Precision = " + this.precision);
        System.out.println(this.mappedMentionCount + " mapped mentions");
    }

    public void summary() {
        System.out.println("");
        System.out.println("Overall Recall = " + this.overallRecall);
        System.out.println("Overall Precision = " + this.overallPrecision);
        float FO = 2.0f / (1.0f / this.overallRecall + 1.0f / this.overallPrecision);
        System.out.println("F = " + FO);
        System.out.println(this.overallMappedMentionCount + " total mapped mentions");
    }

    public static void main(String[] args) throws IOException {
        String home = System.getProperty("user.home") + "\\";
        new AnnotationColor(home + "My Documents\\Jet");
        String keyFile = home + "My Documents\\Jet\\Data\\coref.txt";
        String[] tags = new String[]{"coref"};
        ExternalDocument keyDoc = new ExternalDocument("sgml", keyFile);
        keyDoc.setSGMLtags(tags);
        keyDoc.open();
        CorefFilter.buildEntitiesFromLinkedMentions(keyDoc);
        new View(keyDoc, 0);
        new EntityView(keyDoc, 1);
        JetTest.initializeFromConfig("chunk3.properties");
        String testFile = home + "My Documents\\Jet\\Data\\article.txt";
        Document testDoc = JetTest.readDocument(new BufferedReader(new FileReader(testFile)));
        Control.processDocument(testDoc, null, true, 1);
        new EntityView(testDoc, 2);
        CorefScorer scorer = new CorefScorer();
        scorer.score(testDoc, keyDoc);
        System.out.println("Recall = " + scorer.recall);
        System.out.println("Precision = " + scorer.precision);
    }
}

