/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.refres;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.EDTtype;
import edu.nyu.jet.refres.CorefFilter;
import edu.nyu.jet.refres.CorefScorer;
import edu.nyu.jet.refres.DocumentScorer;
import edu.nyu.jet.refres.EntityView;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.View;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PronounScorer
extends DocumentScorer {
    private static HashSet<String> pronounSet = new HashSet();
    private Document responseDoc;
    private Document keyDoc;
    private Vector responseMentions;
    private HashMap<Annotation, Annotation> responseToKeyMentionMap;
    private HashMap<Annotation, Annotation> responseAntecedent;
    private HashMap<Annotation, Annotation> keyAntecedent;
    public float accuracy;
    public float overallAccuracy;
    private int correct = 0;
    private int pronouns = 0;
    private int totalCorrect = 0;
    private int totalPronouns = 0;

    @Override
    public void score(Document responseDoc, Document keyDoc) {
        this.responseDoc = responseDoc;
        this.keyDoc = keyDoc;
        Vector<Annotation> responseEntities = responseDoc.annotationsOfType("entity");
        if (responseEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in response");
            return;
        }
        Vector<Annotation> keyEntities = keyDoc.annotationsOfType("entity");
        if (keyEntities == null) {
            System.err.println("CorefScorer.score:  no entity annotations in key");
            return;
        }
        this.alignMentions();
        this.responseAntecedent = this.buildAntecedentMap(responseDoc);
        this.keyAntecedent = this.buildAntecedentMap(keyDoc);
        this.accuracy = this.scoreMentions(this.responseMentions);
        this.totalCorrect += this.correct;
        this.totalPronouns += this.pronouns;
        this.overallAccuracy = (float)this.totalCorrect / (float)this.totalPronouns;
    }

    private void alignMentions() {
        HashMap endOfKeyMentionMap = CorefScorer.buildEndOfMentionMap(this.keyDoc);
        this.responseToKeyMentionMap = new HashMap();
        this.responseMentions = CorefScorer.findMentions(this.responseDoc);
        if (this.responseMentions != null) {
            for (int j = 0; j < this.responseMentions.size(); ++j) {
                Annotation responseMention = (Annotation)this.responseMentions.elementAt(j);
                Annotation responseMentionHead = Resolve.getHeadC(responseMention);
                int end = responseMentionHead.span().end();
                Annotation keyMention = (Annotation)endOfKeyMentionMap.get(new Integer(end));
                if (keyMention == null) continue;
                this.responseToKeyMentionMap.put(responseMentionHead, keyMention);
            }
        }
    }

    private HashMap<Annotation, Annotation> buildAntecedentMap(Document doc) {
        HashMap<Annotation, Annotation> antecedentMap = new HashMap<Annotation, Annotation>();
        Vector<Annotation> entities = doc.annotationsOfType("entity");
        for (int i = 0; i < entities.size(); ++i) {
            Annotation entity = entities.get(i);
            Vector mentions = (Vector)entity.get("mentions");
            Annotation antecedent = null;
            for (int j = 0; j < mentions.size(); ++j) {
                Annotation mention = (Annotation)mentions.get(j);
                Annotation mentionHead = Resolve.getHeadC(mention);
                antecedentMap.put(mentionHead, antecedent);
                antecedent = mentionHead;
            }
        }
        return antecedentMap;
    }

    private float scoreMentions(Vector mentions) {
        this.correct = 0;
        this.pronouns = 0;
        for (int i = 0; i < mentions.size(); ++i) {
            Annotation mention = (Annotation)mentions.get(i);
            Annotation mentionHead = Resolve.getHeadC(mention);
            this.scoreMention(mentionHead);
        }
        return (float)this.correct / (float)this.pronouns;
    }

    private void scoreMention(Annotation mentionHead) {
        String headText = this.responseDoc.text(mentionHead).trim().toLowerCase();
        if (!pronounSet.contains(headText)) {
            return;
        }
        Annotation keyMentionHead = this.responseToKeyMentionMap.get(mentionHead);
        if (keyMentionHead == null) {
            return;
        }
        ++this.pronouns;
        Annotation responseAnte = this.responseAntecedent.get(mentionHead);
        Annotation keyAnte = this.keyAntecedent.get(keyMentionHead);
        if (responseAnte == null && keyAnte == null || this.responseToKeyMentionMap.get(responseAnte) == keyAnte) {
            ++this.correct;
        }
        while ((keyAnte = this.keyAntecedent.get(keyAnte)) != null) {
            if (this.responseToKeyMentionMap.get(responseAnte) != keyAnte) continue;
            ++this.correct;
            return;
        }
    }

    @Override
    public void report() {
        System.out.println("Pronoun accuracy = " + this.accuracy);
        System.out.println("( " + this.correct + " correct pronoun antecedents " + "out of " + this.pronouns + " pronouns)");
    }

    @Override
    public void summary() {
        System.out.println("Overall pronoun accuracy = " + this.overallAccuracy);
        System.out.println("( " + this.totalCorrect + " correct pronoun antecedents " + "out of " + this.totalPronouns + " pronouns)");
    }

    public static void main(String[] args) throws IOException {
        String home = System.getProperty("user.home") + "/";
        String keyFile = home + "My Documents/jet/data/coref.txt";
        String[] tags = new String[]{"coref"};
        ExternalDocument keyDoc = new ExternalDocument("sgml", keyFile);
        keyDoc.setSGMLtags(tags);
        keyDoc.open();
        CorefFilter.buildEntitiesFromLinkedMentions(keyDoc);
        new View(keyDoc, 0);
        new EntityView(keyDoc, 0);
        JetTest.initializeFromConfig("props/chunk3.properties");
        EDTtype.readTypeDict();
        String testFile = home + "My Documents\\Jet\\Data\\article.txt";
        Document testDoc = JetTest.readDocument(new BufferedReader(new FileReader(testFile)));
        Control.processDocument(testDoc, null, true, 1);
        PronounScorer scorer = new PronounScorer();
        scorer.score(testDoc, keyDoc);
        scorer.report();
        scorer.summary();
    }

    static {
        pronounSet.add("he");
        pronounSet.add("she");
        pronounSet.add("it");
        pronounSet.add("him");
        pronounSet.add("her");
        pronounSet.add("they");
        pronounSet.add("them");
        pronounSet.add("his");
        pronounSet.add("its");
        pronounSet.add("their");
        pronounSet.add("himself");
        pronounSet.add("herself");
        pronounSet.add("itself");
        pronounSet.add("themselves");
    }
}

