/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.scorer;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.HashMap;
import java.util.Vector;

public class SGMLScorer {
    public Document doc1;
    public Document doc2;
    public Vector mismatch1 = new Vector();
    public Vector mismatch2 = new Vector();
    public int numOfTagsInDoc1 = 0;
    public int numOfTagsInDoc2 = 0;
    public int numOfMatchingTags = 0;
    public int numOfMatchingAttrs = 0;
    public int totalTagsInDoc1 = 0;
    public int totalTagsInDoc2 = 0;
    public int totalMatchingTags = 0;
    public int totalMatchingAttrs = 0;
    String lastTypeMatched = "";
    boolean ignorePeriods = false;

    public SGMLScorer(Document doc1, Document doc2) {
        this.doc1 = doc1;
        this.doc2 = doc2;
    }

    public void match(String annType) {
        this.match(annType, annType);
    }

    public void match(String annType1, String annType2) {
        this.match(annType1, annType2, null);
    }

    public void match(String annType1, String annType2, Span span) {
        this.numOfTagsInDoc1 = 0;
        this.numOfTagsInDoc2 = 0;
        this.numOfMatchingTags = 0;
        this.numOfMatchingAttrs = 0;
        this.lastTypeMatched = annType2;
        Annotation currentAnn1 = null;
        Annotation currentAnn2 = null;
        Vector<Annotation> anns1 = this.doc1.annotationsOfType(annType1, span);
        HashMap anns2 = this.annotationMap(this.doc2.annotationsOfType(annType2, span), this.doc2);
        HashMap mismatchMap1 = this.annotationMap(this.doc1.annotationsOfType(annType1, span), this.doc1);
        HashMap mismatchMap2 = this.annotationMap(this.doc2.annotationsOfType(annType2, span), this.doc2);
        int size1 = 0;
        if (anns1 != null) {
            this.numOfTagsInDoc1 = size1 = anns1.size();
        }
        int size2 = 0;
        if (anns2 != null) {
            this.numOfTagsInDoc2 = size2 = anns2.size();
        }
        if (anns1 != null && anns2 != null) {
            for (int i = 0; i < size1; ++i) {
                currentAnn1 = anns1.get(i);
                Long key = this.annotationKey(currentAnn1, this.doc1);
                currentAnn2 = (Annotation)anns2.get(key);
                if (currentAnn2 == null) continue;
                ++this.numOfMatchingTags;
                Object type1 = currentAnn1.get("TYPE");
                Object type2 = currentAnn2.get("TYPE");
                Object cat1 = currentAnn1.get("CAT");
                Object cat2 = currentAnn2.get("CAT");
                if ((type1 == null ? type2 == null : type1.equals(type2)) && (cat1 == null ? cat2 == null : cat1.equals(cat2))) {
                    ++this.numOfMatchingAttrs;
                    mismatchMap1.remove(key);
                    mismatchMap2.remove(key);
                }
                anns2.remove(key);
                --size2;
            }
        }
        if (mismatchMap1 != null) {
            this.mismatch1.addAll(mismatchMap1.values());
        }
        if (mismatchMap2 != null) {
            for (Annotation a : mismatchMap2.values()) {
                Object status = a.get("STATUS");
                if (status != null && status.equals("OPT")) {
                    --this.numOfTagsInDoc2;
                    continue;
                }
                this.mismatch2.add(a);
            }
        }
        this.totalTagsInDoc1 += this.numOfTagsInDoc1;
        this.totalTagsInDoc2 += this.numOfTagsInDoc2;
        this.totalMatchingTags += this.numOfMatchingTags;
        this.totalMatchingAttrs += this.numOfMatchingAttrs;
    }

    public String report() {
        return "For " + this.lastTypeMatched + ", " + "# of matching tags = " + this.numOfMatchingTags + "    # of tags in response = " + this.numOfTagsInDoc1 + "    # of tags in key = " + this.numOfTagsInDoc2 + "    # with matching attributes = " + this.numOfMatchingAttrs;
    }

    private HashMap annotationMap(Vector annotationVector, Document doc) {
        if (annotationVector == null) {
            return null;
        }
        HashMap<Long, Annotation> map = new HashMap<Long, Annotation>(annotationVector.size());
        for (int i = 0; i < annotationVector.size(); ++i) {
            Annotation ann = (Annotation)annotationVector.get(i);
            Long key = this.annotationKey(ann, doc);
            if (map.containsKey(key)) {
                System.out.println("Duplicate annotation " + ann);
            }
            map.put(key, ann);
        }
        return map;
    }

    private Long annotationKey(Annotation ann, Document doc) {
        int i;
        long start = ann.span().start();
        long end = ann.span().end();
        if (this.ignorePeriods && (i = ann.span().endNoWS(doc)) > 1 && doc.charAt(i - 1) == '.') {
            end = i - 1;
        }
        return new Long(start * 1000000000L + end);
    }
}

