/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberAnnotator {
    private static TObjectIntHashMap numberNames;
    private static TObjectIntHashMap ordinalNumberNames;

    public void annotate(Document doc) {
        Span span = new Span(0, doc.length());
        this.annotate(doc, span);
    }

    public void annotate(Document doc, Span span) {
        Vector<Annotation> v = doc.annotationsOfType("token", span);
        if (v == null) {
            return;
        }
        int size = v.size();
        ArrayList<String> expressions = new ArrayList<String>();
        ArrayList<NumberInformation> numbers = new ArrayList<NumberInformation>();
        int start = span.start();
        for (int i = 0; i < size; ++i) {
            FeatureSet attrs;
            Annotation a = v.get(i);
            String token = doc.text(a).trim();
            if (token.equals("-")) continue;
            NumberInformation num = null;
            if (a.get("intvalue") != null) {
                Integer ii;
                Object iv = a.get("intvalue");
                if (iv instanceof Integer) {
                    ii = (Integer)iv;
                } else if (iv instanceof String) {
                    try {
                        ii = new Integer((String)iv);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("*** invalid intvalue " + a);
                        ii = new Integer(0);
                    }
                } else {
                    System.out.println("*** invalid intvalue " + a);
                    ii = new Integer(0);
                }
                attrs = new FeatureSet("value", ii);
                doc.annotate("number", a.span(), attrs);
            } else {
                num = this.resolveNumber(token);
            }
            if (num != null) {
                if (numbers.isEmpty()) {
                    start = a.start();
                    expressions.clear();
                }
                numbers.add(num);
                expressions.add(token);
                continue;
            }
            if (numbers.isEmpty()) continue;
            if (!this.checkPhoneNumber(expressions)) {
                int value = this.calcNumber(numbers);
                int end = v.get(i - 1).end();
                attrs = new FeatureSet();
                attrs.put("value", new Integer(value));
                if (((NumberInformation)numbers.get(numbers.size() - 1)).isOrdinal()) {
                    attrs.put("ordinal", true);
                }
                doc.annotate("number", new Span(start, end), attrs);
            }
            numbers.clear();
        }
        if (!numbers.isEmpty()) {
            int value = this.calcNumber(numbers);
            int end = v.lastElement().end();
            FeatureSet attrs = new FeatureSet();
            attrs.put("value", new Integer(value));
            if (((NumberInformation)numbers.get(numbers.size() - 1)).isOrdinal()) {
                attrs.put("ordinal", true);
            }
            doc.annotate("number", new Span(start, end), attrs);
        }
    }

    private int calcNumber(List<NumberInformation> v) {
        int result = 0;
        int accum = 0;
        for (NumberInformation n : v) {
            int num = n.getValue();
            if (num >= 1000) {
                result += (accum > 0 ? accum : 1) * num;
                accum = 0;
                continue;
            }
            if (num == 100) {
                accum = (accum > 0 ? accum : 1) * num;
                continue;
            }
            accum += num;
        }
        return result += accum;
    }

    private NumberInformation resolveNumber(String exp) {
        String key = exp.toLowerCase().trim();
        if (key.endsWith(".")) {
            key = key.substring(0, key.length() - 1);
        }
        Pattern numPattern = Pattern.compile("[+-]?\\d*(?:1st|2nd|3rd|[04-9]th)", 2);
        if (numberNames.containsKey((Object)key)) {
            return new NumberInformation(exp, numberNames.get((Object)key), false);
        }
        NumberInformation number = this.resolveOrdinalNumber(exp);
        if (number != null) {
            return number;
        }
        if (numPattern.matcher(key).matches()) {
            int val = Integer.parseInt(key.substring(0, key.length() - 2));
            return new NumberInformation(exp, val, true);
        }
        try {
            int val = Integer.parseInt(key);
            return new NumberInformation(exp, val, false);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private boolean checkPhoneNumber(List<String> expressions) {
        if (expressions.size() == 1) {
            return false;
        }
        Pattern numRegex = Pattern.compile("\\d+");
        for (String expression : expressions) {
            if (numRegex.matcher(expression).matches()) continue;
            return false;
        }
        return true;
    }

    private NumberInformation resolveOrdinalNumber(String exp) {
        String stem;
        String key = exp.toLowerCase();
        if (ordinalNumberNames.containsKey((Object)key)) {
            return new NumberInformation(exp, ordinalNumberNames.get((Object)key), true);
        }
        if (exp.endsWith("th") && numberNames.contains((Object)(stem = exp.substring(0, exp.length() - 2)))) {
            int val = numberNames.get((Object)stem);
            return new NumberInformation(stem, val, true);
        }
        return null;
    }

    static {
        ordinalNumberNames = new TObjectIntHashMap();
        TObjectIntHashMap m = new TObjectIntHashMap();
        m.put((Object)"zero", 0);
        m.put((Object)"one", 1);
        m.put((Object)"two", 2);
        m.put((Object)"three", 3);
        m.put((Object)"four", 4);
        m.put((Object)"five", 5);
        m.put((Object)"six", 6);
        m.put((Object)"seven", 7);
        m.put((Object)"eight", 8);
        m.put((Object)"nine", 9);
        m.put((Object)"ten", 10);
        m.put((Object)"eleven", 11);
        m.put((Object)"twelve", 12);
        m.put((Object)"thirteen", 13);
        m.put((Object)"fourteen", 14);
        m.put((Object)"fifteen", 15);
        m.put((Object)"sixteen", 16);
        m.put((Object)"seventeen", 17);
        m.put((Object)"eighteen", 18);
        m.put((Object)"nineteen", 19);
        m.put((Object)"twenty", 20);
        m.put((Object)"thirty", 30);
        m.put((Object)"forty", 40);
        m.put((Object)"fifty", 50);
        m.put((Object)"sixty", 60);
        m.put((Object)"seventy", 70);
        m.put((Object)"eighty", 80);
        m.put((Object)"ninety", 90);
        m.put((Object)"hundred", 100);
        m.put((Object)"thousand", 1000);
        m.put((Object)"million", 100000);
        numberNames = m;
        TObjectIntHashMap n = new TObjectIntHashMap();
        n.put((Object)"first", 1);
        n.put((Object)"second", 2);
        n.put((Object)"third", 3);
        n.put((Object)"fifth", 5);
        n.put((Object)"eighth", 8);
        n.put((Object)"twelfth", 12);
        ordinalNumberNames = n;
    }

    private static class NumberInformation {
        private boolean ordinal;
        private int value;
        private String token;

        public NumberInformation(String token, int value, boolean ordinal) {
            this.token = token;
            this.value = value;
            this.ordinal = ordinal;
        }

        public boolean isOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(boolean ordinal) {
            this.ordinal = ordinal;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

