/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.time.PatternItem;
import edu.nyu.jet.time.PatternMatchResult;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberPattern
extends PatternItem {
    private int min;
    private int max;
    private Ordinal ordinal;

    public NumberPattern(int min, int max, Ordinal ordinal) {
        this.min = min;
        this.max = max;
        this.ordinal = ordinal;
    }

    public NumberPattern(int min, int max) {
        this(min, max, Ordinal.SHOULD);
    }

    public NumberPattern(Ordinal ordinal) {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, ordinal);
    }

    public NumberPattern() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, Ordinal.SHOULD);
    }

    @Override
    public PatternMatchResult match(Document doc, List<Annotation> tokens, int offset) {
        int start = tokens.get(offset).start();
        Vector<Annotation> numbers = doc.annotationsAt(start, "number");
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        Annotation number = (Annotation)numbers.get(0);
        Number value = (Number)number.get("value");
        Boolean ordinal = (Boolean)number.get("ordinal");
        if (ordinal == null) {
            ordinal = Boolean.FALSE;
        }
        if (this.min <= value.intValue() && value.intValue() <= this.max) {
            if (this.ordinal == Ordinal.MUST && !ordinal.booleanValue()) {
                return null;
            }
            if (this.ordinal == Ordinal.MUST_NOT && ordinal.booleanValue()) {
                return null;
            }
            return new PatternMatchResult(value, number.span());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Ordinal {
        MUST,
        SHOULD,
        MUST_NOT;

    }
}

