/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.time;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.time.TimeRule;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import pnuts.lang.Context;
import pnuts.lang.Package;
import pnuts.lang.ParseException;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.PnutsFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptRule
extends TimeRule {
    private Pnuts pnuts;

    @Override
    public void setParameters(Map params) {
        super.setParameters(params);
        try {
            String script = (String)params.get("script");
            this.pnuts = Pnuts.parse((String)script);
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void apply(Document doc, List<Object> values, Span span, DateTime ref) {
        Map params = this.getParameters();
        Map config = this.getTimeAnnotator().getConfig();
        String format = (String)params.get("format");
        DateTimeFormatter formatter = null;
        if (format != null) {
            formatter = DateTimeFormat.forPattern((String)format);
        }
        Package pkg = new Package();
        pkg.set("ref", (Object)ref);
        pkg.set("formatter", (Object)formatter);
        pkg.set("values", values);
        pkg.set("config", (Object)config);
        pkg.set("doc", (Object)doc);
        pkg.set("span", (Object)span);
        pkg.set("annotate", (Object)new PnutsAnnotateFunction(doc));
        pkg.set("removeAnnotation", (Object)new PnutsRemoveAnnotationFunction(doc));
        Context context = new Context(pkg);
        Object obj = null;
        try {
            obj = this.pnuts.run(context);
        }
        catch (PnutsException e) {
            if (e.getThrowable() instanceof RuntimeException) {
                throw (RuntimeException)e.getThrowable();
            }
            throw e;
        }
        if (obj instanceof DateTime) {
            String val = formatter.print((ReadableInstant)((DateTime)obj));
            FeatureSet attrs = new FeatureSet();
            attrs.put("VAL", val);
            doc.annotate("TIMEX2", span, attrs);
        } else if (obj instanceof FeatureSet) {
            FeatureSet attrs = (FeatureSet)obj;
            doc.annotate("TIMEX2", span, attrs);
        } else if (obj != null) {
            throw new RuntimeException();
        }
    }

    private static class PnutsRemoveAnnotationFunction
    extends PnutsFunction {
        private Document doc;

        public PnutsRemoveAnnotationFunction(Document doc) {
            this.doc = doc;
        }

        public boolean defined(int n) {
            return n == 1;
        }

        public Object exec(Object[] args, Context context) {
            if (!this.defined(args.length)) {
                this.undefined(args, context);
                return null;
            }
            Annotation a = (Annotation)args[0];
            this.doc.removeAnnotation(a);
            return null;
        }
    }

    private static class PnutsAnnotateFunction
    extends PnutsFunction {
        private Document doc;

        public PnutsAnnotateFunction(Document doc) {
            this.doc = doc;
        }

        public boolean defined(int n) {
            return n == 2;
        }

        public Object exec(Object[] args, Context context) {
            FeatureSet attrs;
            if (!this.defined(args.length)) {
                this.undefined(args, context);
                return null;
            }
            Span span = (Span)args[0];
            if (args[1] instanceof FeatureSet) {
                attrs = (FeatureSet)args[1];
            } else if (args[1] instanceof Map) {
                Map map = (Map)args[1];
                attrs = new FeatureSet();
                for (Map.Entry entry : map.entrySet()) {
                    attrs.put((String)entry.getKey(), entry.getValue());
                }
            } else {
                this.undefined(args, context);
                return null;
            }
            this.doc.annotate("TIMEX2", span, attrs);
            return null;
        }
    }
}

