/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationColorEntry;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;

public class AnnotationColor {
    public static ArrayList<AnnotationColorEntry> colors = new ArrayList();
    static File colorFile;
    static JFrame colorFrame;
    static final int ALPHA = 150;

    public AnnotationColor(String dataPath) {
        this(dataPath, "annColors.clr");
    }

    public AnnotationColor(String dataPath, String colorFileName) {
        try {
            colorFile = new File(dataPath, colorFileName);
            if (!colorFile.createNewFile()) {
                System.out.println("Reading colors from file " + colorFile);
                AnnotationColor.readColors();
            }
            if (!JetTest.batchFlag) {
                colorFrame = new JFrame("Customize Annotation Color");
                colorFrame.getContentPane().setLayout(new GridLayout(0, 1));
                colorFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        colorFrame.dispose();
                    }
                });
                AnnotationColor.fillColorFrame();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readColors() {
        try {
            String line;
            colors.clear();
            BufferedReader in = new BufferedReader(new FileReader(colorFile));
            while ((line = in.readLine()) != null) {
                AnnotationColorEntry ace = AnnotationColorEntry.read(line);
                if (ace == null) continue;
                colors.add(ace);
            }
        }
        catch (FileNotFoundException in) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeColors() {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(colorFile)));
            for (AnnotationColorEntry c : colors) {
                out.println(c.toString());
            }
            out.flush();
        }
        catch (IOException e) {
            System.err.println("Error writing to file " + colorFile);
        }
    }

    public static void addType(String type) {
        for (AnnotationColorEntry c : colors) {
            if (!c.type.equals(type)) continue;
            return;
        }
        String color = "0x" + Integer.toHexString(type.hashCode() & 0xFFFFFF);
        colors.add(new AnnotationColorEntry(type, null, null, color, ' '));
        if (colorFile != null) {
            AnnotationColor.writeColors();
            if (!JetTest.batchFlag) {
                AnnotationColor.showColors();
            }
        }
    }

    private static void fillColorFrame() {
        colorFrame.getContentPane().removeAll();
        for (int i = 0; i < colors.size(); ++i) {
            final int buttonNumber = i;
            AnnotationColorEntry c = colors.get(i);
            JButton button = new JButton(c.typeAndFeature());
            try {
                button.setBackground(AnnotationColor.setAlpha(Color.decode(c.color), 150));
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid color for annotation type " + c.typeAndFeature());
            }
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JButton activeButton = (JButton)e.getSource();
                    Color newColor = JColorChooser.showDialog(colorFrame, "Choose Background Color", activeButton.getBackground());
                    if (newColor != null) {
                        activeButton.setBackground(newColor);
                        AnnotationColor.colors.get((int)buttonNumber).color = "0x" + Integer.toHexString(newColor.hashCode() & 0xFFFFFF);
                        AnnotationColor.writeColors();
                    }
                }
            });
            colorFrame.getContentPane().add(button);
        }
    }

    public static void showColors() {
        AnnotationColor.readColors();
        AnnotationColor.fillColorFrame();
        colorFrame.pack();
        colorFrame.setVisible(true);
    }

    public static Color getColor(Annotation ann) {
        String annType = ann.type();
        for (AnnotationColorEntry c : colors) {
            if (!annType.equals(c.type) || c.feature != null && !ann.get(c.feature).equals(c.featureValue)) continue;
            try {
                return AnnotationColor.setAlpha(Color.decode(c.color), 150);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid color for annotation type " + c.typeAndFeature());
            }
        }
        return null;
    }

    private static Color setAlpha(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    static {
        colorFrame = null;
    }
}

