/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.AnnotationColor;
import edu.nyu.jet.tipster.AnnotationColorEntry;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSplitter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class AnnotationTool
extends JFrame {
    private Document document;
    StyledDocument styledDocument;
    StyledDocument styledInstructionDocument;
    private Annotation[] tokens;
    private boolean[] tagged;
    private Annotation[] newAnnotation;
    private int dot;
    private int mark;
    private boolean quit = false;
    private int start;
    private int length;
    private JSplitPane splitPane = new JSplitPane(0);
    private JTextPane textPane = new JTextPane();
    private JTextPane instructionPane = new JTextPane();
    private JScrollPane scrollPane1 = new JScrollPane();
    private JScrollPane scrollPane2 = new JScrollPane();
    private TitledBorder border = new TitledBorder("quack");
    private Keymap keymap;
    private ArrayList actions = new ArrayList();
    private String instructions = "";

    public AnnotationTool() {
        try {
            this.initTool();
            this.setTitle("AnnotationTool");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTool() {
        this.textPane.setEditable(false);
        this.keymap = JTextComponent.addKeymap("AnnotationToolMap", null);
        KeyStroke left = KeyStroke.getKeyStroke(37, 0);
        this.keymap.addActionForKeyStroke(left, new SelectionAction("left"));
        KeyStroke right = KeyStroke.getKeyStroke(39, 0);
        this.keymap.addActionForKeyStroke(right, new SelectionAction("right"));
        KeyStroke shiftLeft = KeyStroke.getKeyStroke(37, 1);
        this.keymap.addActionForKeyStroke(shiftLeft, new SelectionAction("shiftLeft"));
        KeyStroke shiftRight = KeyStroke.getKeyStroke(39, 1);
        this.keymap.addActionForKeyStroke(shiftRight, new SelectionAction("shiftRight"));
        KeyStroke u = KeyStroke.getKeyStroke('u');
        this.keymap.addActionForKeyStroke(u, new UndoAction());
        KeyStroke q = KeyStroke.getKeyStroke('q');
        this.keymap.addActionForKeyStroke(q, new QuitAction(this, false));
        KeyStroke shiftQ = KeyStroke.getKeyStroke('Q');
        this.keymap.addActionForKeyStroke(shiftQ, new QuitAction(this, true));
        KeyStroke blank = KeyStroke.getKeyStroke(' ');
        this.keymap.addActionForKeyStroke(blank, new ScrollAction());
        this.textPane.setKeymap(this.keymap);
        AnnotationToolMouseListener cat = new AnnotationToolMouseListener();
        this.textPane.addMouseListener(cat);
        this.scrollPane1.getViewport().add(this.textPane);
        this.splitPane.setTopComponent(this.scrollPane1);
        this.scrollPane2.getViewport().add(this.instructionPane);
        this.splitPane.setBottomComponent(this.scrollPane2);
        this.splitPane.setResizeWeight(0.8);
        this.border.setTitlePosition(5);
        this.scrollPane1.setBorder(this.border);
        this.setSize(600, 400);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.addWindowListener(new AnnotationToolWindowListener(this));
    }

    public void addType(char key, Annotation annotationPrototype) {
        KeyStroke stroke = KeyStroke.getKeyStroke(key);
        AddAnnotationAction act = new AddAnnotationAction(key, annotationPrototype);
        this.keymap.addActionForKeyStroke(stroke, act);
        this.actions.add(act);
        this.instructions = this.instructions + act.instruction + "\n";
    }

    public synchronized boolean annotateDocument(Document doc, Span annotationZone) {
        this.document = doc;
        this.textPane.setText(this.document.text().toString());
        this.styledDocument = this.textPane.getStyledDocument();
        this.instructionPane.setText(this.instructions);
        this.styledInstructionDocument = this.instructionPane.getStyledDocument();
        int posn = 0;
        for (int i = 0; i < this.actions.size(); ++i) {
            AddAnnotationAction act = (AddAnnotationAction)this.actions.get(i);
            int length = act.instruction.length();
            this.styledInstructionDocument.setCharacterAttributes(posn, length, act.colorAttribute, true);
            posn += length + 1;
        }
        SimpleAttributeSet boldface = new SimpleAttributeSet();
        StyleConstants.setBold(boldface, true);
        this.start = annotationZone.start();
        this.length = annotationZone.endNoWS(this.document) - this.start;
        this.styledDocument.setCharacterAttributes(this.start, this.length, boldface, true);
        this.tokens = Tokenizer.gatherTokens(this.document, annotationZone);
        if (this.tokens.length == 0) {
            System.out.println("Can't annotate document:  not tokenized");
            return false;
        }
        this.tagged = new boolean[this.tokens.length];
        this.newAnnotation = new Annotation[this.tokens.length];
        this.markPreAnnotations();
        this.dot = 0;
        this.mark = 0;
        this.highlightSelection(true);
        if (doc instanceof ExternalDocument) {
            ExternalDocument edoc = (ExternalDocument)doc;
            String fileName = edoc.fileName();
            this.setTitle("AnnotationTool:  " + fileName);
        }
        this.setVisible(true);
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.quit;
    }

    private void markPreAnnotations() {
        for (int itoken = 0; itoken < this.tokens.length; ++itoken) {
            Annotation token = this.tokens[itoken];
            int start = token.start();
            int end = token.end();
            Vector<Annotation> annotations = this.document.annotationsAt(start);
            block1: for (int i = 0; i < annotations.size(); ++i) {
                Annotation ann = annotations.get(i);
                for (int j = 0; j < this.actions.size(); ++j) {
                    AddAnnotationAction act = (AddAnnotationAction)this.actions.get(j);
                    if (!ann.type().equals(act.annotationType) || !act.fs.subsetOf(ann.attributes())) continue;
                    int k = itoken;
                    while (this.tokens[k].span().end() <= end) {
                        this.tagged[k] = true;
                        ++k;
                    }
                    this.newAnnotation[itoken] = ann;
                    this.border.setTitle(ann.toString());
                    this.scrollPane1.repaint();
                    int length = ann.span().endNoWS(this.document) - start;
                    this.styledDocument.setCharacterAttributes(start, length, act.colorAttribute, false);
                    continue block1;
                }
            }
        }
    }

    private void highlightSelection(boolean highlight) {
        SimpleAttributeSet selection = new SimpleAttributeSet();
        StyleConstants.setUnderline(selection, highlight);
        int startToken = Math.min(this.dot, this.mark);
        int endToken = Math.max(this.dot, this.mark);
        int start = this.tokens[startToken].span().start();
        int length = this.tokens[endToken].span().endNoWS(this.document) - start;
        this.styledDocument.setCharacterAttributes(start, length, selection, false);
        Annotation ann = this.newAnnotation[startToken];
        if (highlight) {
            this.border.setTitle(ann == null ? " " : ann.toString());
            this.scrollPane1.repaint();
        }
    }

    String[] addTypes(AnnotationColor ac) {
        ArrayList<AnnotationColorEntry> colors = AnnotationColor.colors;
        HashSet<String> typeSet = new HashSet<String>();
        for (int i = 0; i < colors.size(); ++i) {
            AnnotationColorEntry entry = colors.get(i);
            Annotation ann = new Annotation(entry.type, null, new FeatureSet(entry.feature, entry.featureValue));
            char key = entry.key;
            this.addType(key, ann);
            typeSet.add(entry.type);
        }
        String[] types = typeSet.toArray(new String[0]);
        return types;
    }

    public static void main(String[] args) {
        Span textSpan;
        if (args.length != 2) {
            System.err.println("AnnotationTool requires two arguments:  document  colorFile");
            System.exit(1);
        }
        String docFile = args[0];
        String colorFile = args[1];
        AnnotationColor ac = new AnnotationColor(".", colorFile);
        AnnotationColor.showColors();
        AnnotationTool tool = new AnnotationTool();
        String[] types = tool.addTypes(ac);
        JetTest.encoding = "UTF-8";
        ExternalDocument doc = new ExternalDocument("sgml", docFile);
        doc.setSGMLtags(types);
        doc.open();
        doc.annotateWithTag("TEXT");
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        if (textSegments != null && textSegments.size() > 0) {
            Annotation text = textSegments.get(0);
            textSpan = text.span();
        } else {
            textSpan = doc.fullSpan();
        }
        SentenceSplitter.split(doc, textSpan);
        Vector<Annotation> sentences = doc.annotationsOfType("sentence");
        if (sentences == null) {
            return;
        }
        for (Annotation sentence : sentences) {
            Span sentenceSpan = sentence.span();
            Tokenizer.tokenize(doc, sentenceSpan);
        }
        tool.annotateDocument(doc, textSpan);
        doc.removeAnnotationsOfType("token");
        doc.shrinkAll();
        doc.setSGMLwrapMargin(0);
        doc.save();
        System.exit(0);
    }

    int findToken(int charPos) {
        if (charPos < 0) {
            return charPos;
        }
        for (int i = 0; i < this.tokens.length; ++i) {
            if (charPos < this.tokens[i].start() || charPos >= this.tokens[i].end()) continue;
            return i;
        }
        return -1;
    }

    class AnnotationToolMouseListener
    implements MouseListener {
        AnnotationToolMouseListener() {
        }

        public void mousePressed(MouseEvent event) {
            Point point = event.getPoint();
            int charPos = AnnotationTool.this.textPane.viewToModel(point);
            int token = AnnotationTool.this.findToken(charPos);
            if (token >= 0) {
                AnnotationTool.this.highlightSelection(false);
                AnnotationTool.this.dot = token;
                AnnotationTool.this.mark = token;
                AnnotationTool.this.highlightSelection(true);
            }
        }

        public void mouseReleased(MouseEvent event) {
            Point point = event.getPoint();
            int charPos = AnnotationTool.this.textPane.viewToModel(point);
            int token = AnnotationTool.this.findToken(charPos);
            if (token >= 0) {
                AnnotationTool.this.highlightSelection(false);
                AnnotationTool.this.mark = token;
                AnnotationTool.this.highlightSelection(true);
            }
        }

        public void mouseClicked(MouseEvent event) {
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }
    }

    class AnnotationToolWindowListener
    extends WindowAdapter {
        AnnotationTool tool;

        public AnnotationToolWindowListener(AnnotationTool t) {
            this.tool = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void windowClosing(WindowEvent evt) {
            AnnotationTool.this.dispose();
            AnnotationTool annotationTool = this.tool;
            synchronized (annotationTool) {
                this.tool.notify();
            }
        }
    }

    class AddAnnotationAction
    extends AbstractAction {
        char keychar;
        String annotationType;
        FeatureSet fs;
        Color color;
        SimpleAttributeSet colorAttribute;
        String instruction;

        AddAnnotationAction(char c, Annotation ann) {
            this.keychar = c;
            this.annotationType = ann.type();
            this.fs = ann.attributes();
            Color color = AnnotationColor.getColor(ann);
            this.colorAttribute = new SimpleAttributeSet();
            StyleConstants.setBackground(this.colorAttribute, color);
            this.instruction = this.keychar + ": " + this.annotationType;
            if (this.fs != null) {
                this.instruction = this.instruction + " " + this.fs;
            }
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            int startToken = Math.min(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int endToken = Math.max(AnnotationTool.this.dot, AnnotationTool.this.mark);
            for (i = startToken; i <= endToken; ++i) {
                if (!AnnotationTool.this.tagged[i]) continue;
                JOptionPane.showMessageDialog(null, "Can't add annotation:\nselection already has annotation", "Error", 0);
                return;
            }
            for (i = startToken; i <= endToken; ++i) {
                ((AnnotationTool)AnnotationTool.this).tagged[i] = true;
            }
            int start = AnnotationTool.this.tokens[startToken].span().start();
            int end = AnnotationTool.this.tokens[endToken].span().end();
            Annotation newAnn = new Annotation(this.annotationType, new Span(start, end), this.fs);
            AnnotationTool.this.document.addAnnotation(newAnn);
            ((AnnotationTool)AnnotationTool.this).newAnnotation[startToken] = newAnn;
            AnnotationTool.this.border.setTitle(newAnn.toString());
            AnnotationTool.this.scrollPane1.repaint();
            int length = AnnotationTool.this.tokens[endToken].span().endNoWS(AnnotationTool.this.document) - start;
            AnnotationTool.this.styledDocument.setCharacterAttributes(start, length, this.colorAttribute, false);
        }
    }

    class QuitAction
    extends AbstractAction {
        AnnotationTool tool;
        boolean stopLearner;

        public QuitAction(AnnotationTool t, boolean stop) {
            this.tool = t;
            this.stopLearner = stop;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            AnnotationTool.this.dispose();
            if (this.stopLearner) {
                AnnotationTool.this.quit = true;
            }
            AnnotationTool annotationTool = this.tool;
            synchronized (annotationTool) {
                this.tool.notify();
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        UndoAction() {
        }

        public void actionPerformed(ActionEvent e) {
            int startToken = Math.min(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int endToken = Math.max(AnnotationTool.this.dot, AnnotationTool.this.mark);
            int start = AnnotationTool.this.tokens[startToken].span().start();
            int end = AnnotationTool.this.tokens[endToken].span().end();
            Annotation ann = AnnotationTool.this.newAnnotation[startToken];
            if (ann == null || ann.span().end() != end) {
                JOptionPane.showMessageDialog(null, "Can't undo:\nselection doesn't correspond to annotation", "Error", 0);
                return;
            }
            ((AnnotationTool)AnnotationTool.this).newAnnotation[startToken] = null;
            for (int i = startToken; i <= endToken; ++i) {
                ((AnnotationTool)AnnotationTool.this).tagged[i] = false;
            }
            AnnotationTool.this.document.removeAnnotation(ann);
            int length = AnnotationTool.this.tokens[endToken].span().endNoWS(AnnotationTool.this.document) - start;
            SimpleAttributeSet colorAttribute = new SimpleAttributeSet();
            StyleConstants.setBackground(colorAttribute, Color.white);
            AnnotationTool.this.styledDocument.setCharacterAttributes(start, length, colorAttribute, false);
            AnnotationTool.this.border.setTitle(" ");
            AnnotationTool.this.scrollPane1.repaint();
        }
    }

    class SelectionAction
    extends AbstractAction {
        String key;

        SelectionAction(String key) {
            this.key = key;
        }

        public void actionPerformed(ActionEvent e) {
            AnnotationTool.this.highlightSelection(false);
            if (this.key == "left") {
                if (AnnotationTool.this.dot > 0) {
                    AnnotationTool.this.dot--;
                }
                AnnotationTool.this.mark = AnnotationTool.this.dot;
            } else if (this.key == "right") {
                if (AnnotationTool.this.dot < AnnotationTool.this.tokens.length - 1) {
                    AnnotationTool.this.dot++;
                }
                AnnotationTool.this.mark = AnnotationTool.this.dot;
            } else if (this.key == "shiftLeft") {
                if (AnnotationTool.this.dot > 0) {
                    AnnotationTool.this.dot--;
                }
            } else if (this.key == "shiftRight" && AnnotationTool.this.dot < AnnotationTool.this.tokens.length - 1) {
                AnnotationTool.this.dot++;
            }
            AnnotationTool.this.highlightSelection(true);
        }
    }

    class ScrollAction
    extends AbstractAction {
        ScrollAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                Rectangle r = AnnotationTool.this.textPane.modelToView(AnnotationTool.this.start + AnnotationTool.this.length);
                AnnotationTool.this.textPane.scrollRectToVisible(r);
            }
            catch (BadLocationException ee) {
                System.out.println("AnnotationTool:  invalid selected sentence");
            }
        }
    }
}

