/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.parser.SyntacticRelationSet;
import edu.nyu.jet.refres.Resolve;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Span;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Document
implements Serializable {
    StringBuffer text;
    private Hashtable annotationsByStart;
    private Hashtable annotationsByEnd;
    private Hashtable annotationsByType;
    private int nextAnnotationId;
    private Object currentHypothesis = null;
    private Set activeHypotheses = null;
    private int sgmlWrapMargin = 80;
    private int sgmlIndent = 0;
    boolean strictNesting = false;
    public SyntacticRelationSet relations;

    public Document() {
        this.text = new StringBuffer();
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
        this.relations = new SyntacticRelationSet();
    }

    public Document(String stg) {
        this.text = new StringBuffer(stg);
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
        this.relations = new SyntacticRelationSet();
    }

    public Document(Document doc) {
        this.text = new StringBuffer(doc.text);
        this.annotationsByStart = new Hashtable();
        this.annotationsByEnd = new Hashtable();
        this.annotationsByType = new Hashtable();
        this.nextAnnotationId = 0;
        String[] types = doc.getAnnotationTypes();
        for (int i = 0; i < types.length; ++i) {
            Vector<Annotation> v = doc.annotationsOfType(types[i]);
            for (int j = 0; j < v.size(); ++j) {
                Annotation a = v.get(j);
                FeatureSet fs = null;
                if (a.attributes != null) {
                    fs = new FeatureSet(a.attributes);
                }
                this.annotate(types[i], a.span(), fs);
            }
        }
        this.relations = new SyntacticRelationSet();
    }

    public void clear() {
        this.text.setLength(0);
        this.annotationsByStart.clear();
        this.annotationsByEnd.clear();
        this.annotationsByType.clear();
        this.nextAnnotationId = 0;
        this.relations = new SyntacticRelationSet();
    }

    public void setText(String stg) {
        this.text = new StringBuffer(stg);
    }

    public String text() {
        return this.text.toString();
    }

    public String text(Span s) {
        return this.text.substring(s.start(), s.end());
    }

    public String text(Annotation ann) {
        return this.text(ann.span());
    }

    public String normalizedText(Span s) {
        return Resolve.normalizeName(this.text.substring(s.start(), s.end()));
    }

    public String normalizedText(Annotation ann) {
        return this.normalizedText(ann.span());
    }

    public StringBuffer append(String stg) {
        return this.text.append(stg);
    }

    public StringBuffer append(char c) {
        return this.text.append(c);
    }

    public int length() {
        return this.text.length();
    }

    public Span fullSpan() {
        return new Span(0, this.text.length());
    }

    public char charAt(int posn) {
        return this.text.charAt(posn);
    }

    public void setCharAt(int posn, char c) {
        this.text.setCharAt(posn, c);
    }

    public void clearAnnotations() {
        this.annotationsByStart.clear();
        this.annotationsByEnd.clear();
        this.annotationsByType.clear();
    }

    public Annotation addAnnotation(Annotation ann) {
        Integer start = new Integer(ann.span.start);
        if (!this.annotationsByStart.containsKey(start)) {
            this.annotationsByStart.put(start, new Vector());
        }
        Vector vs = (Vector)this.annotationsByStart.get(start);
        vs.add(ann);
        Integer end = new Integer(ann.span.end);
        if (!this.annotationsByEnd.containsKey(end)) {
            this.annotationsByEnd.put(end, new Vector());
        }
        Vector ve = (Vector)this.annotationsByEnd.get(end);
        ve.add(ann);
        String type = ann.type;
        if (!this.annotationsByType.containsKey(type)) {
            this.annotationsByType.put(type, new Vector());
        }
        Vector vt = (Vector)this.annotationsByType.get(type);
        vt.add(ann);
        if (this.currentHypothesis != null) {
            ann.put("hypo", this.currentHypothesis);
        }
        Span s = ann.span();
        s.setDocument(this);
        return ann;
    }

    public Annotation annotate(String tp, Span sp, FeatureSet att) {
        return this.addAnnotation(new Annotation(tp, sp, att));
    }

    public void removeAnnotation(Annotation ann) {
        String type;
        Vector vt;
        Integer end;
        Vector ve;
        Integer start = new Integer(ann.span.start);
        Vector vs = (Vector)this.annotationsByStart.get(start);
        if (vs != null) {
            vs.remove(ann);
        }
        if ((ve = (Vector)this.annotationsByEnd.get(end = new Integer(ann.span.end))) != null) {
            ve.remove(ann);
        }
        if ((vt = (Vector)this.annotationsByType.get(type = ann.type)) != null) {
            vt.remove(ann);
        }
    }

    public void removeAnnotationsOfType(String type) {
        Vector<Annotation> v = this.annotationsOfType(type);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = v.get(i);
            this.removeAnnotation(a);
        }
    }

    public Vector<Annotation> annotationsAt(int start) {
        Integer s = new Integer(start);
        Vector v = (Vector)this.annotationsByStart.get(s);
        if (v == null) {
            return null;
        }
        return this.activeAnnotations(v);
    }

    public Vector<Annotation> annotationsAt(int start, String type) {
        Vector<Annotation> annAt = this.annotationsAt(start);
        if (annAt == null) {
            return null;
        }
        Vector<Annotation> result = null;
        for (int i = 0; i < annAt.size(); ++i) {
            Annotation ann = annAt.get(i);
            if (!ann.type().equals(type)) continue;
            if (result == null) {
                result = new Vector<Annotation>();
            }
            result.addElement(ann);
        }
        return result;
    }

    public Vector<Annotation> annotationsAt(int start, String[] types) {
        Vector<Annotation> annAt = this.annotationsAt(start);
        if (annAt == null) {
            return null;
        }
        Vector<Annotation> result = null;
        for (Annotation ann : annAt) {
            for (String type : types) {
                if (!ann.type().equals(type)) continue;
                if (result == null) {
                    result = new Vector<Annotation>();
                }
                result.addElement(ann);
            }
        }
        return result;
    }

    public Vector<Annotation> annotationsEndingAt(int end) {
        Integer e = new Integer(end);
        Vector v = (Vector)this.annotationsByEnd.get(e);
        if (v == null) {
            return null;
        }
        return this.activeAnnotations(v);
    }

    public Vector<Annotation> annotationsEndingAt(int end, String type) {
        Vector<Annotation> annAt = this.annotationsEndingAt(end);
        if (annAt == null) {
            return null;
        }
        Vector<Annotation> result = null;
        for (int i = 0; i < annAt.size(); ++i) {
            Annotation ann = annAt.get(i);
            if (!ann.type().equals(type)) continue;
            if (result == null) {
                result = new Vector<Annotation>();
            }
            result.addElement(ann);
        }
        return result;
    }

    public Annotation tokenAt(int start) {
        Vector<Annotation> annAt = this.annotationsAt(start);
        if (annAt == null) {
            return null;
        }
        for (int i = 0; i < annAt.size(); ++i) {
            Annotation ann = annAt.get(i);
            if (!ann.type().equals("token")) continue;
            return ann;
        }
        return null;
    }

    public Annotation tokenEndingAt(int end) {
        Vector<Annotation> annAt = this.annotationsEndingAt(end);
        if (annAt == null) {
            return null;
        }
        for (int i = 0; i < annAt.size(); ++i) {
            Annotation ann = annAt.get(i);
            if (!ann.type().equals("token")) continue;
            return ann;
        }
        return null;
    }

    public Vector<Annotation> annotationsOfType(String type) {
        Vector v = (Vector)this.annotationsByType.get(type);
        return this.activeAnnotations(v);
    }

    public Vector<Annotation> annotationsOfType(String type, Span span) {
        Vector<Annotation> v = this.annotationsOfType(type);
        if (v == null) {
            return null;
        }
        if (span == null) {
            return v;
        }
        Vector<Annotation> result = new Vector<Annotation>();
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = v.get(i);
            if (!a.span().within(span)) continue;
            result.add(a);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    public void setCurrentHypothesis(Object hypoId) {
        this.currentHypothesis = hypoId;
    }

    public void setActiveHypotheses(Set hypoIdSet) {
        this.activeHypotheses = hypoIdSet;
    }

    private Vector<Annotation> activeAnnotations(Vector anns) {
        if (anns == null) {
            return null;
        }
        if (this.activeHypotheses == null) {
            return (Vector)anns.clone();
        }
        Vector<Annotation> newanns = new Vector<Annotation>(anns.size());
        for (int i = 0; i < anns.size(); ++i) {
            Annotation a = (Annotation)anns.get(i);
            Object hypoId = a.get("hypo");
            if (hypoId != null && !this.activeHypotheses.contains(hypoId)) continue;
            newanns.add(a);
        }
        return newanns;
    }

    public String[] getAnnotationTypes() {
        return this.annotationsByType.keySet().toArray(new String[0]);
    }

    public void annotateWithTag(String tag, int start, int end) {
        String closeTag = "/" + tag;
        int tagStart = 0;
        int tagEnd = 0;
        FeatureSet fs = new FeatureSet();
        StringBuffer token = null;
        boolean collecting = false;
        for (int i = start; i < end && i < this.text.length(); ++i) {
            char c = this.text.charAt(i);
            if (c == '<') {
                collecting = true;
                token = new StringBuffer();
                tagEnd = i - 1;
                continue;
            }
            if (!collecting) continue;
            if (c == '>') {
                collecting = false;
                String tagName = token.toString();
                if (tagName.equalsIgnoreCase(tag)) {
                    tagStart = i + 1;
                    continue;
                }
                if (!tagName.equalsIgnoreCase(closeTag)) continue;
                if (tagStart != 0 && tagEnd != 0 && tagStart < tagEnd) {
                    this.annotate(tag, new Span(tagStart, tagEnd), fs);
                }
                tagStart = 0;
                continue;
            }
            token.append(c);
        }
    }

    public void annotateWithTag(String tag) {
        this.annotateWithTag(tag, 0, this.length());
    }

    public int getNextAnnotationId() {
        return this.nextAnnotationId++;
    }

    public void setSGMLwrapMargin(int n) {
        this.sgmlWrapMargin = n;
    }

    public void setSGMLindent(int n) {
        this.sgmlIndent = n;
    }

    public StringBuffer writeSGML(String type) {
        if (type == null) {
            return this.writeSGML(null, 0, this.text.length());
        }
        return this.writeSGML(new String[]{type}, 0, this.text.length());
    }

    public StringBuffer writeSGML(String type, Span span) {
        if (type == null) {
            return this.writeSGML(null, span.start(), span.end());
        }
        return this.writeSGML(new String[]{type}, span.start(), span.end());
    }

    public StringBuffer writeSGML(String[] types, int start, int end) {
        this.prepareToWriteSGML(types);
        StringBuffer result = new StringBuffer();
        int column = 0;
        Stack<Annotation> openAnnotations = new Stack<Annotation>();
        for (int ichar = start; ichar < end; ++ichar) {
            String annType;
            Vector<Annotation> annotationsStartingHere = types == null ? this.annotationsAt(ichar) : this.annotationsAt(ichar, types);
            if (annotationsStartingHere != null) {
                Annotation.sort(annotationsStartingHere);
                if (this.strictNesting) {
                    int nextClose;
                    int furthestCloseOfNewAnnotations;
                    if (!openAnnotations.empty() && (furthestCloseOfNewAnnotations = annotationsStartingHere.get(0).span().end()) > (nextClose = ((Annotation)openAnnotations.peek()).span().end())) {
                        System.err.println("writeSGML:  annotations not nested.");
                        System.err.println(annotationsStartingHere.get(0) + " crosses " + openAnnotations.peek());
                    }
                } else {
                    block1: for (Annotation ann : annotationsStartingHere) {
                        for (int i = openAnnotations.size() - 1; i >= 0; --i) {
                            Annotation openAnn = (Annotation)openAnnotations.get(i);
                            if (!ann.type().equals(openAnn.type)) continue;
                            if (ann.span().end() <= openAnn.span().end()) continue block1;
                            System.err.println("writeSGML:  annotations of same type not nested.");
                            System.err.println(openAnn + " crosses " + ann);
                            continue block1;
                        }
                    }
                }
                for (Annotation ann : annotationsStartingHere) {
                    int annEnd = ann.span().end();
                    if (annEnd > end) {
                        System.err.println("writeSGML:  annotation extending past end of span was suppressed");
                        System.err.println("            " + ann);
                        continue;
                    }
                    String annString = ann.toSGMLString();
                    if (this.sgmlIndent > 0) {
                        if (openAnnotations.empty()) {
                            column += annString.length();
                        } else {
                            annString = "<\n" + this.blankString(openAnnotations.size() * this.sgmlIndent) + annString.substring(1);
                            column = annString.length() - 2;
                        }
                    } else if (this.sgmlWrapMargin > 0 && column + annString.length() > this.sgmlWrapMargin) {
                        annString = annString.substring(0, annString.length() - 1) + "\n>";
                        column = 1;
                    } else {
                        column += annString.length();
                    }
                    result.append(annString);
                    openAnnotations.push(ann);
                }
                Annotation.sort(openAnnotations);
            }
            while (!openAnnotations.empty() && ((Annotation)openAnnotations.peek()).span().end() == ichar) {
                annType = ((Annotation)openAnnotations.peek()).type();
                String annString = "</" + annType + ">";
                result.append(annString);
                openAnnotations.pop();
            }
            result.append(this.text.charAt(ichar));
            column = this.text.charAt(ichar) == '\n' ? 0 : ++column;
            while (!openAnnotations.empty() && ((Annotation)openAnnotations.peek()).span().end() == 1 + ichar) {
                annType = ((Annotation)openAnnotations.peek()).type();
                if (this.sgmlIndent > 0) {
                    result.append("<\n" + this.blankString((openAnnotations.size() - 1) * this.sgmlIndent) + "/" + annType + ">");
                    column = annType.length() + 1;
                } else {
                    result.append("</" + annType + ">");
                    column += annType.length() + 3;
                }
                openAnnotations.pop();
            }
        }
        while (!openAnnotations.empty()) {
            System.err.println("Internal writeSGML error:  didn't close annotation " + openAnnotations.pop());
        }
        return result;
    }

    private void prepareToWriteSGML(String[] types) {
        for (int ichar = 0; ichar < this.text.length(); ++ichar) {
            Vector<Annotation> annotationsStartingHere = types == null ? this.annotationsAt(ichar) : this.annotationsAt(ichar, types);
            if (annotationsStartingHere == null) continue;
            for (int i = 0; i < annotationsStartingHere.size(); ++i) {
                Annotation ann = annotationsStartingHere.get(i);
                ann.prepareToMakeString(1);
            }
        }
    }

    private String blankString(int len) {
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void stretch(Annotation ann) {
        int posn;
        this.removeAnnotation(ann);
        Span s = ann.span();
        for (posn = s.end(); posn < this.text.length() && this.annotationsByStart.get(posn) == null && Character.isWhitespace(this.charAt(posn)); ++posn) {
        }
        s.setEnd(posn);
        this.addAnnotation(ann);
    }

    public void stretch(String type) {
        Vector<Annotation> v = this.annotationsOfType(type);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation ann = v.get(i);
            this.stretch(ann);
        }
    }

    public void stretchAll() {
        String[] types = this.getAnnotationTypes();
        for (int i = 0; i < types.length; ++i) {
            this.stretch(types[i]);
        }
    }

    public void shrink(Annotation ann) {
        int posn;
        this.removeAnnotation(ann);
        Span s = ann.span();
        int start = s.start();
        for (posn = s.end(); posn > start && Character.isWhitespace(this.charAt(posn - 1)); --posn) {
        }
        s.setEnd(posn);
        this.addAnnotation(ann);
    }

    public void shrink(String type) {
        Vector<Annotation> v = this.annotationsOfType(type);
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation ann = v.get(i);
            this.shrink(ann);
        }
    }

    public void shrinkAll() {
        String[] types = this.getAnnotationTypes();
        for (int i = 0; i < types.length; ++i) {
            this.shrink(types[i]);
        }
    }
}

