/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.JetTest;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.scorer.SGMLProcessor;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class ExternalDocument
extends Document {
    private boolean open;
    private String format;
    private String directory;
    private String fileName;
    private String[] SGMLtags = new String[0];
    private boolean allTags = false;
    private String[] emptyTags = null;

    public ExternalDocument(String format, String fileName) {
        this.format = format;
        this.directory = null;
        this.fileName = fileName;
        this.open = false;
    }

    public ExternalDocument(String format, String directory, String fileName) {
        this.format = format;
        this.directory = directory;
        this.fileName = fileName;
        this.open = false;
    }

    public void setSGMLtags(String[] tags) {
        this.SGMLtags = tags;
    }

    public void setAllTags(boolean allTags) {
        this.allTags = allTags;
    }

    public void setEmptyTags(String[] tags) {
        this.emptyTags = tags;
    }

    public boolean open() {
        if (!this.open) {
            try {
                if (this.format.equals("sgml")) {
                    String line;
                    File file = new File(this.fullFileName());
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), JetTest.encoding));
                    StringBuffer fileText = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        fileText.append(line + "\n");
                    }
                    String text = fileText.toString();
                    SGMLProcessor.allTags = this.allTags;
                    SGMLProcessor.emptyTags = this.emptyTags;
                    Document doc = SGMLProcessor.sgmlToDoc((Document)this, text, this.SGMLtags);
                    this.open = true;
                    return true;
                }
                if (this.format.equals("pos")) {
                    this.posRead();
                    this.open = true;
                    return true;
                }
                System.out.println("Error opening document " + this.fileName);
                System.out.println("Unknown document format.");
                return false;
            }
            catch (IOException e) {
                System.out.println("Error opening document " + this.fileName);
                System.out.println(e);
                return false;
            }
        }
        return true;
    }

    private void posRead() throws IOException {
        String line;
        File file = new File(this.fullFileName());
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer fileText = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line);
            while (st.hasMoreTokens()) {
                String tokenAndPos = st.nextToken();
                int slashIndex = tokenAndPos.lastIndexOf(47);
                if (slashIndex <= 0) {
                    throw new IOException("invalid data");
                }
                String token = tokenAndPos.substring(0, slashIndex);
                String pos = tokenAndPos.substring(1 + slashIndex).intern();
                int start = this.length();
                this.append(token);
                if (st.hasMoreTokens()) {
                    this.append(" ");
                } else {
                    this.append(" \n");
                }
                int end = this.length();
                Span span = new Span(start, end);
                this.annotate("token", span, new FeatureSet());
                this.annotate("constit", span, new FeatureSet("cat", pos));
            }
        }
    }

    public void save() {
        if (!this.open) {
            System.out.println("ExternalDocument.save:  attempt to save unopened document " + this.fileName);
            return;
        }
        try {
            if (this.format.equals("sgml")) {
                String tagToWrite;
                if (this.allTags) {
                    tagToWrite = null;
                } else if (this.SGMLtags.length == 0) {
                    tagToWrite = "***";
                } else if (this.SGMLtags.length == 1) {
                    tagToWrite = this.SGMLtags[0];
                } else {
                    System.out.println("ExternalDocument.save:  cannot write more than 1 annotation type");
                    return;
                }
                String string = this.writeSGML(tagToWrite).toString();
                File file = new File(this.fullFileName());
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), JetTest.encoding));
                ExternalDocument.writeWithSystemNewlines(writer, string);
                writer.close();
            } else {
                System.out.println("Error saving document " + this.fileName);
                System.out.println("Unknown document format.");
            }
        }
        catch (IOException e) {
            System.out.println("Error opening document " + this.fileName);
            System.out.println(e);
        }
    }

    public static void writeWithSystemNewlines(BufferedWriter writer, String string) throws IOException {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\n') {
                writer.newLine();
                continue;
            }
            writer.write(c);
        }
    }

    public void saveIn(String directory) {
        this.directory = directory;
        this.save();
    }

    public void saveAs(String directory, String fileName) {
        this.directory = directory;
        this.fileName = fileName;
        this.save();
    }

    public boolean isOpen() {
        return this.open;
    }

    public String format() {
        return this.format;
    }

    public String directory() {
        return this.directory;
    }

    public String fileName() {
        return this.fileName;
    }

    public String fullFileName() {
        if (this.directory == null || this.directory.equals("")) {
            return this.fileName;
        }
        return this.directory + File.separator + this.fileName;
    }
}

