/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.tipster;

import edu.nyu.jet.tipster.Document;

public class Span
implements Comparable {
    int start;
    int end;
    Document doc;

    public Span(int s, int e) {
        this.start = s;
        this.end = e;
        this.doc = null;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void setStart(int s) {
        this.start = s;
    }

    public void setEnd(int e) {
        this.end = e;
    }

    public int endNoWS(Document doc) {
        int pos;
        for (pos = this.end; pos > this.start && Character.isWhitespace(doc.charAt(pos - 1)); --pos) {
        }
        return pos;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Document document() {
        return this.doc;
    }

    public boolean equals(Object o) {
        if (o instanceof Span) {
            Span s = (Span)o;
            return this.start == s.start && this.end == s.end;
        }
        return false;
    }

    public int hashCode() {
        return this.start * 513 + this.end;
    }

    public boolean within(Span s) {
        return this.start >= s.start && this.end <= s.end;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Span)) {
            throw new ClassCastException();
        }
        Span s = (Span)o;
        if (this.start < s.start) {
            return -1;
        }
        if (this.start > s.start) {
            return 1;
        }
        if (this.end < s.end) {
            return -1;
        }
        if (this.end > s.end) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.start + " - " + this.end + "]";
    }
}

