/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public final class Cdb {
    private ByteBuffer map;
    private int loop;
    private int khash;
    private int kpos;
    private int hpos;
    private int hslots;

    public Cdb(File file) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel channel = raf.getChannel();
        this.map = channel.map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
        this.map.order(ByteOrder.LITTLE_ENDIAN);
        channel.close();
    }

    public Cdb(String filename) throws IOException {
        this(new File(filename));
    }

    public void close() {
        this.map = null;
    }

    public void findstart() {
        this.loop = 0;
    }

    public byte[] findNext(byte[] key, int offset, int len) {
        int u;
        if (this.loop == 0) {
            u = Cdb.hash(key, offset, len);
            this.map.position(u << 3 & 0x7FF);
            this.hpos = this.map.getInt();
            this.hslots = this.map.getInt();
            if (this.hslots == 0) {
                return null;
            }
            this.khash = u;
            u >>>= 8;
            u %= this.hslots;
            this.kpos = this.hpos + (u <<= 3);
        }
        while (this.loop < this.hslots) {
            this.map.position(this.kpos);
            u = this.map.getInt();
            int pos = this.map.getInt();
            if (pos == 0) {
                return null;
            }
            ++this.loop;
            this.kpos += 8;
            if (this.kpos == this.hpos + (this.hslots << 3)) {
                this.kpos = this.hpos;
            }
            if (u != this.khash) continue;
            this.map.position(pos);
            u = this.map.getInt();
            if (u != len) continue;
            int dlen = this.map.getInt();
            byte[] keyInDb = new byte[len];
            this.map.get(keyInDb, 0, len);
            if (!Cdb.match(key, offset, len, keyInDb)) continue;
            byte[] data = new byte[dlen];
            this.map.get(data, 0, dlen);
            return data;
        }
        return null;
    }

    public byte[] findNext(byte[] key) {
        return this.findNext(key, 0, key.length);
    }

    public byte[] find(byte[] key, int offset, int len) {
        this.findstart();
        return this.findNext(key, offset, len);
    }

    public byte[] find(byte[] key) {
        return this.find(key, 0, key.length);
    }

    static int hash(byte[] key, int offset, int len) {
        long h = 5381L;
        long mask = 0xFFFFFFFFL;
        for (int i = 0; i < len; ++i) {
            h = h + (h << 5) & 0xFFFFFFFFL & 0xFFFFFFFFL;
            h ^= (long)(key[offset + i] + 256 & 0xFF);
        }
        return (int)(h & 0xFFFFFFFFL);
    }

    private static boolean match(byte[] key, int offset, int len, byte[] keyInDb) {
        if (keyInDb.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (key[offset + i] == keyInDb[i]) continue;
            return false;
        }
        return true;
    }
}

