/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.zoner;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSet {
    private Vector<Annotation> sentences;
    private int[] sentenceBoundaries;

    public SentenceSet(Document doc) {
        this.sentences = doc.annotationsOfType("sentence");
        if (this.sentences == null) {
            this.sentences = new Vector();
        }
        this.sentenceBoundaries = new int[this.sentences.size()];
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentenceBoundaries[i] = this.sentences.get(i).span().start();
        }
    }

    public Vector<Annotation> sentences() {
        return this.sentences;
    }

    public int size() {
        return this.sentences.size();
    }

    public int sentencesBetween(int posn1, int posn2) {
        int count = 0;
        for (int i = 0; i < this.sentenceBoundaries.length; ++i) {
            if (posn1 >= this.sentenceBoundaries[i] || this.sentenceBoundaries[i] > posn2) continue;
            ++count;
        }
        return count;
    }

    public int sentenceNumber(int posn) {
        for (int i = 1; i < this.sentenceBoundaries.length; ++i) {
            if (posn >= this.sentenceBoundaries[i]) continue;
            return i - 1;
        }
        return this.sentenceBoundaries.length - 1;
    }

    public boolean inSameSentence(int posn1, int posn2) {
        return this.sentencesBetween(posn1, posn2) == 0;
    }

    public int pseudoHobbsDistance(int posn1, int posn2) {
        if (this.sentencesBetween(posn1, posn2) == 0) {
            return posn2 - posn1;
        }
        for (int i = 0; i < this.sentenceBoundaries.length - 1; ++i) {
            if (posn1 < this.sentenceBoundaries[i] || posn1 >= this.sentenceBoundaries[i + 1]) continue;
            return posn1 - this.sentenceBoundaries[i] + (posn2 - this.sentenceBoundaries[i + 1]) + 1;
        }
        return 99999;
    }
}

