/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.zoner;

import edu.nyu.jet.lex.Tokenizer;
import edu.nyu.jet.lisp.FeatureSet;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.Span;
import java.util.Vector;

public class SpecialZoner {
    static String[] agency = new String[]{"(AFP)", "(AP)", "(Xinhua)"};

    public static void findSpecialZones(Document doc) {
        Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
        if (textSegments == null || textSegments.size() == 0) {
            return;
        }
        Annotation textAnn = textSegments.get(0);
        Span textSpan = textAnn.span();
        int textOffset = textSpan.start();
        String text = doc.text(textAnn);
        SpecialZoner.findDateline(doc, textOffset, text);
        SpecialZoner.findTextBreaks(doc, textOffset, text);
    }

    public static void findDateline(Document doc, int textOffset, String text) {
        int datelineEnd = -1;
        for (int j = 0; j < agency.length; ++j) {
            int i = text.indexOf(agency[j]);
            if (i <= 0 || i >= 80) continue;
            datelineEnd = text.indexOf(agency[j]) + agency[j].length();
            datelineEnd = Tokenizer.skipWS(text, datelineEnd, text.length());
            break;
        }
        if (datelineEnd > 0) {
            doc.annotate("dateline", new Span(textOffset, textOffset + datelineEnd), new FeatureSet());
        }
    }

    public static void findTextBreaks(Document doc, int textOffset, String text) {
        int lineStart = 0;
        while (lineStart < text.length()) {
            String line;
            int lineEnd = text.indexOf(10, lineStart);
            if (lineEnd < 0) {
                lineEnd = text.length();
            }
            if ((line = text.substring(lineStart, lineEnd).trim()).length() == 0 || line.matches("^[-_~]+$")) {
                doc.annotate("textBreak", new Span(lineStart + textOffset, lineEnd + textOffset), new FeatureSet());
            }
            lineStart = lineEnd + 1;
        }
    }
}

