/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.zoner;

import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.Document;
import edu.nyu.jet.tipster.DocumentCollection;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import java.util.Vector;

public class SpeechSplitter {
    static final double SENTENCE_GAP = 0.25;
    static boolean trace = true;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collectionFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/asr pilot sgm.txt";

    public static void split(Document doc, Span textSpan) {
        int start = textSpan.start();
        int end = textSpan.end();
        double lastEndTime = -1.0;
        Vector<Annotation> Ws = doc.annotationsOfType("W");
        for (int iw = 0; iw < Ws.size(); ++iw) {
            double Dur;
            double Bsec;
            Annotation W = Ws.get(iw);
            String BsecStg = (String)W.get("Bsec");
            String DurStg = (String)W.get("Dur");
            try {
                Bsec = Double.parseDouble(BsecStg);
                Dur = Double.parseDouble(DurStg);
            }
            catch (NumberFormatException e) {
                System.out.println("Speech splitter:  ill-formed W annotation " + W);
                return;
            }
            if (lastEndTime >= 0.0 && Bsec > lastEndTime + 0.25) {
                int posn = W.start();
                Span span = new Span(start, posn);
                doc.annotate("sentence", span, null);
                if (trace) {
                    System.out.println("Sentence: " + doc.text(span).replace('\n', ' '));
                }
                start = posn;
            }
            lastEndTime = Bsec + Dur;
        }
        if (lastEndTime >= 0.0) {
            Span span = new Span(start, end);
            doc.annotate("sentence", span, null);
            if (trace) {
                System.out.println("Sentence: " + doc.text(span).replace('\n', ' '));
            }
        }
    }

    public static void main(String[] args) {
        DocumentCollection collection = new DocumentCollection(collectionFile);
        collection.open();
        for (int i = 0; i < collection.size(); ++i) {
            ExternalDocument doc = collection.get(i);
            System.out.println("Processing document " + doc.fileName());
            doc.setAllTags(true);
            doc.setEmptyTags(new String[]{"W"});
            doc.open();
            doc.annotateWithTag("text");
            Span textSpan = doc.annotationsOfType("TEXT").get(0).span();
            SpeechSplitter.split(doc, textSpan);
        }
    }
}

