/*
 * Decompiled with CFR 0.152.
 */
package edu.nyu.jet.zoner;

import edu.nyu.jet.Control;
import edu.nyu.jet.JetTest;
import edu.nyu.jet.aceJet.Ace;
import edu.nyu.jet.tipster.Annotation;
import edu.nyu.jet.tipster.ExternalDocument;
import edu.nyu.jet.tipster.Span;
import edu.nyu.jet.zoner.SentenceSplitter;
import edu.nyu.jet.zoner.SpecialZoner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class TaggedSentenceWriter {
    static String dataDir;
    static String outputDir;
    static String[] types;

    public static void main(String[] args) throws IOException {
        if (args.length != 4) {
            System.out.println("TaggedSentenceWriter must have 4 arguments:");
            System.out.println("  propertyFile  filelist  dataDirectory  outputDirectory");
            System.exit(1);
        }
        String propertyFile = args[0];
        String fileList = args[1];
        dataDir = args[2];
        outputDir = args[3];
        JetTest.initializeFromConfig(propertyFile);
        String typeProperty = JetTest.getConfig("WriteSGML.type");
        types = typeProperty == null ? new String[]{"ENAMEX"} : (typeProperty.equals("all") ? null : typeProperty.split("\\s*,\\s*"));
        TaggedSentenceWriter.processFileList(fileList);
    }

    private static void processFileList(String fileList) throws IOException {
        String currentDoc;
        BufferedReader reader = new BufferedReader(new FileReader(fileList));
        int docCount = 0;
        while ((currentDoc = reader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++docCount + ": " + currentDoc);
            String textFileName = dataDir + currentDoc;
            ExternalDocument doc = new ExternalDocument("sgml", textFileName);
            doc.setAllTags(true);
            doc.open();
            Ace.monocase = Ace.allLowerCase(doc);
            Control.processDocument(doc, null, false, docCount);
            for (String type : types) {
                doc.shrink(type);
            }
            String sentFileName = outputDir + currentDoc + ".nesent";
            PrintWriter writer = new PrintWriter(new FileWriter(sentFileName));
            TaggedSentenceWriter.writeSents(doc, currentDoc, writer);
            writer.close();
        }
    }

    private static void writeSents(ExternalDocument doc, String currentDocPath, PrintWriter writer) {
        Vector<Annotation> sentences;
        Vector<Annotation> priorSentences = doc.annotationsOfType("sentence");
        if (priorSentences == null || priorSentences.size() == 0) {
            doc.annotateWithTag("TEXT");
            SpecialZoner.findSpecialZones(doc);
            Vector<Annotation> textSegments = doc.annotationsOfType("TEXT");
            if (textSegments == null) {
                System.out.println("No <TEXT> in " + currentDocPath + ", skipped.");
                return;
            }
            for (Annotation ann : textSegments) {
                Span textSpan = ann.span();
                Ace.monocase = Ace.allLowerCase(doc);
                SentenceSplitter.split(doc, textSpan);
            }
        }
        if ((sentences = doc.annotationsOfType("sentence")) == null) {
            return;
        }
        for (Annotation sentence : sentences) {
            Span sentenceSpan = sentence.span();
            String sentenceText = doc.writeSGML(types, sentenceSpan.start(), sentenceSpan.end()).toString().trim().replace('\n', ' ');
            writer.println(sentenceSpan.start() + " " + sentenceText);
        }
    }
}

