/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.etc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

class QueryEngineSim {
    private final PriorityQueue<PartialSolutionSim> deletionQueue = new PriorityQueue();
    private final Map<TriplePatternSim, List<PartialSolutionSim>> index = new HashMap<TriplePatternSim, List<PartialSolutionSim>>();

    public void addQuery(int size) {
        PartialSolutionSim ps = new PartialSolutionSim(size, 0L);
        this.add(ps);
    }

    public void addStatement(int window) {
    }

    private void add(PartialSolutionSim ps) {
        for (TriplePatternSim tp : ps.graphPattern) {
            List<PartialSolutionSim> solutions = this.index.get(tp);
            if (null == solutions) {
                solutions = new LinkedList<PartialSolutionSim>();
                this.index.put(tp, solutions);
            }
            solutions.add(ps);
        }
    }

    private void remove(PartialSolutionSim ps) {
        for (TriplePatternSim tp : ps.graphPattern) {
            List<PartialSolutionSim> solutions = this.index.get(tp);
            if (null == solutions) continue;
            solutions.remove(ps);
            if (0 != solutions.size()) continue;
            this.index.remove(tp);
        }
    }

    private void cleanup() {
    }

    private class PartialSolutionSim
    implements Comparable<PartialSolutionSim> {
        private final long expirationTime = 0L;
        private final List<TriplePatternSim> graphPattern = new LinkedList<TriplePatternSim>();

        public PartialSolutionSim(int size, long expirationTime) {
            for (int i = 0; i < size; ++i) {
                this.graphPattern.add(new TriplePatternSim());
            }
        }

        @Override
        public int compareTo(PartialSolutionSim other) {
            return Long.valueOf(0L).compareTo(other.expirationTime);
        }
    }

    private class TriplePatternSim {
        private TriplePatternSim() {
        }
    }
}

