/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.etc;

import edu.rpi.twc.sesamestream.BindingSetHandler;
import edu.rpi.twc.sesamestream.SesameStream;
import edu.rpi.twc.sesamestream.etc.StatementCollector;
import edu.rpi.twc.sesamestream.impl.PartialSolution;
import edu.rpi.twc.sesamestream.impl.QueryEngineImpl;
import edu.rpi.twc.sesamestream.impl.Visitor;
import info.aduna.io.IOUtil;
import info.aduna.iteration.CloseableIteration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.query.impl.EmptyBindingSet;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.QueryParser;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;

public class QueryEngineTestBase {
    protected static final String BASE_URI = "http://example.org/base/";
    protected QueryParser queryParser = new SPARQLParser();
    protected Sail sail;
    protected QueryEngineImpl queryEngine;
    protected ValueFactory vf = new ValueFactoryImpl();
    protected String ex = "http://example.org/";
    protected String foaf = "http://xmlns.com/foaf/0.1/";
    protected URI arthur = this.vf.createURI(this.ex + "arthur");
    protected URI zaphod = this.vf.createURI(this.ex + "zaphod");
    protected URI ford = this.vf.createURI(this.ex + "ford");
    protected URI knows = this.vf.createURI(this.foaf + "knows");
    protected BindingSetHandler simpleBindingSetHandler = new BindingSetHandler(){

        public void handle(BindingSet result) {
            System.out.println("result: " + result);
        }
    };
    private long count;

    protected TupleExpr loadQuery(String fileName) throws Exception {
        InputStream in = SesameStream.class.getResourceAsStream(fileName);
        String query = IOUtil.readString((InputStream)in);
        in.close();
        ParsedQuery pq = this.queryParser.parseQuery(query, BASE_URI);
        return pq.getTupleExpr();
    }

    protected List<Statement> loadData(String fileName) throws Exception {
        RDFFormat format = RDFFormat.forFileName((String)fileName);
        if (null == format) {
            throw new IllegalStateException("unsupported file extension");
        }
        RDFParser p = Rio.createParser((RDFFormat)format);
        p.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
        LinkedList<Statement> c = new LinkedList<Statement>();
        p.setRDFHandler((RDFHandler)new StatementCollector(c));
        InputStream in = fileName.startsWith("/") ? new FileInputStream(new File(fileName)) : SesameStream.class.getResourceAsStream(fileName);
        p.parse(in, BASE_URI);
        in.close();
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<BindingSet>[] distinctStaticQueryAnswers(List<Statement> data, TupleExpr ... queries) throws Exception {
        Set[] answers = new Set[queries.length];
        int i = 0;
        for (TupleExpr query : queries) {
            HashSet<Object> results;
            answers[i] = results = new HashSet<Object>();
            SailConnection sc = this.sail.getConnection();
            try {
                sc.begin();
                for (Statement s : data) {
                    sc.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{s.getContext()});
                }
                CloseableIteration iter = sc.evaluate(query, (Dataset)new DatasetImpl(), (BindingSet)new EmptyBindingSet(), false);
                try {
                    while (iter.hasNext()) {
                        results.add(iter.next());
                    }
                }
                finally {
                    iter.close();
                }
            }
            finally {
                sc.rollback();
                sc.close();
            }
            ++i;
        }
        return answers;
    }

    protected Set<BindingSet>[] distinctContinuousQueryAnswers(List<Statement> data, TupleExpr ... queries) throws Exception {
        final Set[] answers = new Set[queries.length];
        this.queryEngine.clear();
        int i = 0;
        for (TupleExpr t : queries) {
            answers[i] = new HashSet();
            final int id = i++;
            BindingSetHandler h = new BindingSetHandler(){
                private final Set<BindingSet> a;
                {
                    this.a = answers[id];
                }

                public void handle(BindingSet result) {
                    this.a.add(result);
                }
            };
            this.queryEngine.addQuery(t, h);
        }
        for (Statement s : data) {
            this.queryEngine.addStatement(s);
        }
        return answers;
    }

    protected Collection<BindingSet> continuousQueryAnswers(List<Statement> data, TupleExpr query, final boolean debug) throws Exception {
        final LinkedList<BindingSet> answers = new LinkedList<BindingSet>();
        this.queryEngine.clear();
        BindingSetHandler h = new BindingSetHandler(){

            public void handle(BindingSet result) {
                if (debug) {
                    System.out.println("result: " + result);
                }
                answers.add(result);
            }
        };
        this.queryEngine.addQuery(query, h);
        for (Statement s : data) {
            this.queryEngine.addStatement(s);
        }
        HashSet<BindingSet> distinct = new HashSet<BindingSet>();
        distinct.addAll(answers);
        if (debug) {
            System.out.println("" + answers.size() + " solutions (" + distinct.size() + " distinct, " + this.countPartialSolutions() + " partial) from " + data.size() + " statements");
        }
        return answers;
    }

    protected synchronized long countPartialSolutions() {
        this.count = 0L;
        this.queryEngine.getIndex().visitPartialSolutions(new Visitor<PartialSolution>(){

            @Override
            public boolean visit(PartialSolution ps) {
                QueryEngineTestBase.this.count++;
                return true;
            }
        });
        return this.count;
    }

    public class NullBindingSetHandler
    implements BindingSetHandler {
        public void handle(BindingSet result) {
        }
    }
}

