/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.etc;

import edu.rpi.twc.sesamestream.BindingSetHandler;
import edu.rpi.twc.sesamestream.QueryEngine;
import edu.rpi.twc.sesamestream.etc.ErrorTolerantValueFactory;
import edu.rpi.twc.sesamestream.etc.QueryEngineAdder;
import edu.rpi.twc.sesamestream.impl.QueryEngineImpl;
import info.aduna.io.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.sparql.SPARQLParser;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class TestRunner {
    public static void main(String[] args) throws Exception {
        if (2 != args.length) {
            TestRunner.printUsageAndExit();
        }
        try {
            List<String> queryFiles = TestRunner.getLines(args[0]);
            List<String> dataFiles = TestRunner.getLines(args[1]);
            TestRunner.doRun(queryFiles, dataFiles);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRun(List<String> queryFiles, List<String> dataFiles) throws IOException, MalformedQueryException, QueryEngine.IncompatibleQueryException, RDFHandlerException {
        QueryEngineImpl engine = new QueryEngineImpl();
        SPARQLParser queryParser = new SPARQLParser();
        String baseUri = "http://example.org/base-uri/";
        BindingSetHandler bsh = new BindingSetHandler(){

            public void handle(BindingSet result) {
                StringBuilder sb = new StringBuilder("RESULT\t" + System.currentTimeMillis() + "\t");
                boolean first = true;
                for (String n : result.getBindingNames()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(n).append(":").append(result.getValue(n));
                }
                System.out.println(sb);
            }
        };
        for (String f : queryFiles) {
            System.out.println("RUN\t" + System.currentTimeMillis() + "\tadding query file " + f);
            FileInputStream in = new FileInputStream(new File(f));
            try {
                String query = IOUtil.readString((InputStream)in);
                ParsedQuery pq = queryParser.parseQuery(query, baseUri);
                engine.addQuery(pq.getTupleExpr(), bsh);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        for (String f : dataFiles) {
            System.out.println("RUN\t" + System.currentTimeMillis() + "\tadding data file " + f);
            RDFFormat format = RDFFormat.forFileName((String)f);
            if (null == format) {
                System.err.println("no RDF format matching file name " + f);
                continue;
            }
            QueryEngineAdder h = new QueryEngineAdder(engine);
            FileInputStream in = new FileInputStream(new File(f));
            try {
                RDFParser p = Rio.createParser((RDFFormat)format);
                p.setValueFactory((ValueFactory)new ErrorTolerantValueFactory((ValueFactory)new ValueFactoryImpl()));
                p.setStopAtFirstError(false);
                p.setVerifyData(false);
                p.setRDFHandler((RDFHandler)h);
                try {
                    p.parse((InputStream)in, baseUri);
                }
                catch (RDFParseException e) {
                    System.err.println("RUN ERROR: parse error: " + e.getMessage());
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        System.out.println("RUN\t" + System.currentTimeMillis() + "\tfinished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getLines(String fileName) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        FileInputStream in = new FileInputStream(new File(fileName));
        try {
            String line;
            BufferedReader b = new BufferedReader(new InputStreamReader(in));
            while (null != (line = b.readLine())) {
                lines.add(line.trim());
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return lines;
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: TestRunner list-of-queries.txt list-of-data-files.txt");
        System.exit(1);
    }
}

