/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.twc.sesamestream.impl;

import java.util.Collection;

public class LList<T> {
    public static LList NIL = new LList();
    private final T value;
    private final LList<T> rest;

    private LList() {
        this.value = null;
        this.rest = null;
    }

    public LList(T value, LList<T> rest) {
        this.value = value;
        this.rest = rest;
    }

    public LList(Collection<T> values) {
        if (0 == values.size()) {
            throw new IllegalArgumentException();
        }
        LList<Object> restCur = NIL;
        T valueCur = null;
        for (T t : values) {
            if (!restCur.isNil()) {
                restCur = new LList<Object>(valueCur, restCur);
            }
            valueCur = t;
        }
        this.rest = restCur;
        this.value = valueCur;
    }

    public boolean isNil() {
        return null == this.rest;
    }

    public T getValue() {
        return this.value;
    }

    public LList<T> getRest() {
        return this.rest;
    }

    public LList<T> push(T t) {
        return new LList<T>(t, this);
    }

    public static <T> LList<T> union(LList<T> first, LList<T> second) {
        LList<T> cur1 = second;
        LList<T> cur2 = first;
        while (!cur2.isNil()) {
            cur1 = new LList<T>(cur2.value, cur1);
            cur2 = cur2.rest;
        }
        return cur1;
    }

    public int length() {
        LList<T> cur = this;
        int l = 0;
        while (!cur.isNil()) {
            ++l;
            cur = cur.rest;
        }
        return l;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LList(");
        boolean first = true;
        LList<T> cur = this;
        while (!cur.isNil()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(cur.value);
            cur = cur.rest;
        }
        sb.append(")");
        return sb.toString();
    }
}

